(function ($) {
    'use strict';

    function htmlBlockEditLink() {
        $('.alpha-edit-block-link').each(function () {
            var $link = $(this),
                $wrapper = $link.closest($link.attr('data-parent'));

            if (!$wrapper.length) {
                return;
            }

            var $select = $wrapper.find('select');

            if (!$select.length) {
                return;
            }

            changeLink();

            $select.on('change', function () {
                changeLink();
            });

            function changeLink() {
                var selectValue = $select.find('option:selected').val(),
                    currentHref = $link.attr('href');

                var newHref = currentHref.split('post=')[0] + 'post=' + selectValue + '&action=';
                if (alpha_block_edit_vars.elementor) {
                    newHref += 'elementor';
                } else {
                    newHref += 'edit';
                }

                if (!selectValue || '0' === selectValue || 0 === selectValue) {
                    $link.hide();
                    $link.siblings('.alpha-add-block-link').show();
                } else {
                    $link.attr('href', newHref).show();
                    $link.siblings('.alpha-add-block-link').hide();
                }
            }
        });
    }

    $(document).ready(function () {
        htmlBlockEditLink();
    });
})(jQuery);