<?php
/**
 * Alpha Elementor Single Product Price Widget
 *
 * @author     Andon
 * @package    Alpha Core Framework
 * @subpackage Core
 * @since      4.1
 */
defined( 'ABSPATH' ) || die;

use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Color;
use Elementor\Group_Control_Typography;

class Alpha_Single_Product_Price_Elementor_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return ALPHA_NAME . '_sproduct_price';
	}

	public function get_title() {
		return esc_html__( 'Product Price', 'alpha-core' );
	}

	public function get_icon() {
		return 'alpha-elementor-widget-icon eicon-product-price';
	}

	public function get_categories() {
		return array( 'alpha_single_product_widget' );
	}

	public function get_keywords() {
		return array( 'single', 'custom', 'layout', 'product', 'woocommerce', 'shop', 'store', 'price' );
	}

	public function has_widget_inner_wrapper(): bool {
		return ! Plugin::$instance->experiments->is_feature_active( 'e_optimized_markup' );
	}

	protected function register_controls() {

		$left  = is_rtl() ? 'right' : 'left';
		$right = 'left' === $left ? 'right' : 'left';

		$this->start_controls_section(
			'section_product_price',
			array(
				'label' => esc_html__( 'Style', 'alpha-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

			$this->add_control(
				'sp_title_align',
				array(
					'label'     => esc_html__( 'Alignment', 'alpha-core' ),
					'type'      => Controls_Manager::CHOOSE,
					'options'   => array(
						'left'   => array(
							'title' => esc_html__( 'Left', 'alpha-core' ),
							'icon'  => 'eicon-text-align-left',
						),
						'center' => array(
							'title' => esc_html__( 'Center', 'alpha-core' ),
							'icon'  => 'eicon-text-align-center',
						),
						'right'  => array(
							'title' => esc_html__( 'Right', 'alpha-core' ),
							'icon'  => 'eicon-text-align-right',
						),
					),
					'selectors' => array(
						'{{WRAPPER}} .elementor-container' => 'text-align: {{VALUE}};',
					),
				)
			);

			$this->add_control(
				'heading_price_style',
				array(
					'label'     => esc_html__( 'Price', 'alpha-core' ),
					'type'      => Controls_Manager::HEADING,
					'separator' => 'before',
				)
			);

			$this->start_controls_tabs( 'sp_tabs' );
				$this->start_controls_tab(
					'sp_normal_tab',
					array(
						'label' => esc_html__( 'Normal', 'alpha-core' ),
					)
				);

					$this->add_group_control(
						Group_Control_Typography::get_type(),
						array(
							'name'     => 'sp_typo',
							'label'    => esc_html__( 'Typography', 'alpha-core' ),
							'selector' => '{{WRAPPER}} p.price, {{WRAPPER}} .price del',
						)
					);

					$this->add_control(
						'sp_normal_color',
						array(
							'label'     => esc_html__( 'Color', 'alpha-core' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => array(
								'{{WRAPPER}} p.price' => 'color: {{VALUE}};',
							),
						)
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
					'sp_new_tab',
					array(
						'label' => esc_html__( 'New', 'alpha-core' ),
					)
				);

					$this->add_group_control(
						Group_Control_Typography::get_type(),
						array(
							'name'     => 'sp_new_typo',
							'label'    => esc_html__( 'Typography', 'alpha-core' ),
							'selector' => '{{WRAPPER}} p.price ins',
						)
					);

					$this->add_control(
						'sp_new_color',
						array(
							'label'     => esc_html__( 'Color', 'alpha-core' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => array(
								'{{WRAPPER}} ins' => 'color: {{VALUE}};',
							),
						)
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
					'sp_old_tab',
					array(
						'label' => esc_html__( 'Old', 'alpha-core' ),
					)
				);

					$this->add_group_control(
						Group_Control_Typography::get_type(),
						array(
							'name'     => 'sp_old_typo',
							'label'    => esc_html__( 'Typography', 'alpha-core' ),
							'selector' => '{{WRAPPER}} p.price del',
						)
					);

					$this->add_control(
						'sp_old_color',
						array(
							'label'     => esc_html__( 'Color', 'alpha-core' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => array(
								'{{WRAPPER}} del' => 'color: {{VALUE}};',
							),
						)
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		if ( function_exists( 'alpha_get_option' ) && alpha_get_option( 'product_unit' ) ) {

			$this->add_control(
				'heading_unit_style',
				array(
					'label'     => esc_html__( 'Unit', 'alpha-core' ),
					'type'      => Controls_Manager::HEADING,
					'separator' => 'before',
				)
			);

			$this->add_responsive_control(
				'sp_unit_spacing',
				array(
					'label'       => esc_html__( 'Spacing', 'alpha-core' ),
					'description' => esc_html__( 'Controls the spacing between price and product unit.', 'alpha-core' ),
					'type'        => Controls_Manager::SLIDER,
					'size_units'  => array(
						'px',
						'rem',
						'em',
					),
					'range'       => array(
						'px'  => array(
							'min' => 0,
							'max' => 100,
						),
						'rem' => array(
							'min' => 0,
							'max' => 10,
						),
						'em'  => array(
							'min' => 0,
							'max' => 10,
						),
					),
					'selectors'   => array(
						'{{WRAPPER}} .product-attr' => "margin-{$left}: {{SIZE}}{{UNIT}};",
					),
				)
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				array(
					'name'     => 'sp_unit_typo',
					'label'    => esc_html__( 'Typography', 'alpha-core' ),
					'selector' => '{{WRAPPER}} .product-attr',
				)
			);

			$this->add_control(
				'sp_unit_color',
				array(
					'label'     => esc_html__( 'Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .product-attr' => 'color: {{VALUE}};',
					),
				)
			);
		}

			$this->add_control(
				'heading_price_info_style',
				array(
					'label'     => esc_html__( 'Price Info', 'alpha-core' ),
					'type'      => Controls_Manager::HEADING,
					'separator' => 'before',
				)
			);

			$this->add_responsive_control(
				'sp_price_info_spacing',
				array(
					'label'       => esc_html__( 'Spacing', 'alpha-core' ),
					'description' => esc_html__( 'Controls the spacing between price and price info. You can input each product info in product edit page.', 'alpha-core' ),
					'type'        => Controls_Manager::SLIDER,
					'size_units'  => array(
						'px',
						'rem',
						'em',
					),
					'range'       => array(
						'px'  => array(
							'min' => 0,
							'max' => 100,
						),
						'rem' => array(
							'min' => 0,
							'max' => 10,
						),
						'em'  => array(
							'min' => 0,
							'max' => 10,
						),
					),
					'selectors'   => array(
						'{{WRAPPER}} .product-extra-info' => "margin-{$left}: {{SIZE}}{{UNIT}};",
					),
				)
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				array(
					'name'     => 'sp_price_info_typo',
					'label'    => esc_html__( 'Typography', 'alpha-core' ),
					'selector' => '{{WRAPPER}} .product-extra-info',
				)
			);

			$this->add_control(
				'sp_price_info_color',
				array(
					'label'     => esc_html__( 'Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .product-extra-info' => 'color: {{VALUE}};',
					),
				)
			);

		$this->end_controls_section();
	}

	protected function render() {
		if ( apply_filters( 'alpha_single_product_builder_set_preview', false ) ) {
			woocommerce_template_single_price();
			do_action( 'alpha_single_product_builder_unset_preview' );
		}
	}
}
