<?php
/**
 * Alpha Single Product Elementor Cart Form
 *
 * @author     Andon
 * @package    Alpha Core Framework
 * @subpackage Core
 * @since      4.1
 */
defined( 'ABSPATH' ) || die;

use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;

class Alpha_Single_Product_Cart_Form_Elementor_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return ALPHA_NAME . '_sproduct_cart_form';
	}

	public function get_title() {
		return esc_html__( 'Add To Cart', 'alpha-core' );
	}

	public function get_icon() {
		return 'alpha-elementor-widget-icon eicon-product-add-to-cart';
	}

	public function get_categories() {
		return array( 'alpha_single_product_widget' );
	}

	public function get_keywords() {
		return array( 'single', 'custom', 'layout', 'product', 'woocommerce', 'shop', 'store', 'cart_form', 'variation', 'stock', 'quantity', 'status', 'stock status' );
	}

	public function get_style_depends() {
		if ( isset( $_REQUEST['elementor-preview'] ) ) {
			return array( 'alpha-product-buy-now', 'alpha-progressbar' );
		}
		return array( 'alpha-product-buy-now' );
	}

	public function has_widget_inner_wrapper(): bool {
		return ! Plugin::$instance->experiments->is_feature_active( 'e_optimized_markup' );
	}

	public function get_script_depends() {
		$depends = array();
		if ( isset( $_REQUEST['elementor-preview'] ) ) {
			$depends[] = 'alpha-progress-bar';
		}
		return $depends;
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_cf_stock',
			array(
				'label' => esc_html__( 'Stock Status', 'alpha-core' ),
			)
		);

			$this->add_control(
				'sp_stock_progressbar',
				array(
					'label'       => esc_html__( 'Stock Progressbar', 'alpha-core' ),
					'type'        => Controls_Manager::SWITCHER,
					'description' => esc_html__( 'Display a number of sold and in stock products as a progress bar.', 'alpha-core' ),
				)
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_cf_cart',
			array(
				'label' => esc_html__( 'Sticky Cart Form', 'alpha-core' ),
			)
		);

			$this->add_control(
				'sp_sticky',
				array(
					'label'       => esc_html__( 'Sticky Add To Cart', 'alpha-core' ),
					'type'        => Controls_Manager::SWITCHER,
					'description' => esc_html__( 'Make a selection to show or hide the bottom sticky add to cart.', 'alpha-core' ),
				)
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_cf_variations_style',
			array(
				'label' => esc_html__( 'Attributes', 'alpha-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

			$this->add_control(
				'sp_variations_spacing',
				array(
					'label'     => esc_html__( 'Spacing', 'alpha-core' ),
					'type'      => Controls_Manager::SLIDER,
					'selectors' => array(
						'.elementor-element-{{ID}} .variations' => 'margin-bottom: {{SIZE}}{{UNIT}}',
					),
				)
			);

			$this->add_control(
				'sp_variations_spacing_between',
				array(
					'label'     => esc_html__( 'Space Between', 'alpha-core' ),
					'type'      => Controls_Manager::SLIDER,
					'selectors' => array(
						'.elementor-element-{{ID}} .variations>:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}}',
					),
				)
			);

			$this->add_control(
				'heading_variations_label_style',
				array(
					'label'     => esc_html__( 'Label', 'alpha-core' ),
					'type'      => Controls_Manager::HEADING,
					'separator' => 'before',
				)
			);

			$this->add_control(
				'sp_variations_label_color_focus',
				array(
					'label'     => esc_html__( 'Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .cart label' => 'color: {{VALUE}}',
					),
				)
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				array(
					'name'     => 'sp_variations_label_typo',
					'selector' => '.elementor-element-{{ID}} .cart label',
				)
			);

			$this->add_control(
				'sp_label_spacing',
				array(
					'label'     => esc_html__( 'Spacing', 'alpha-core' ),
					'type'      => Controls_Manager::SLIDER,
					'selectors' => array(
						'.elementor-element-{{ID}} .cart label' => 'margin-right: {{SIZE}}{{UNIT}}',
					),
				)
			);

			$this->add_control(
				'heading_variations_select_style',
				array(
					'label'     => esc_html__( 'Select Field', 'alpha-core' ),
					'type'      => Controls_Manager::HEADING,
					'separator' => 'before',
				)
			);

			$this->add_control(
				'sp_variations_select_color',
				array(
					'label'     => esc_html__( 'Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .cart select' => 'color: {{VALUE}}',
					),
				)
			);

			$this->add_control(
				'sp_variations_select_bg_color',
				array(
					'label'     => esc_html__( 'Background Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .cart select' => 'background-color: {{VALUE}} !important',
					),
				)
			);

			$this->add_control(
				'sp_variations_select_border_color',
				array(
					'label'     => esc_html__( 'Border Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .cart select' => 'border: 1px solid {{VALUE}}',
					),
				)
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				array(
					'name'     => 'sp_variations_select_typo',
					'selector' => '.elementor-element-{{ID}} .cart select',
				)
			);

			$this->add_control(
				'sp_variations_select_border_radius',
				array(
					'label'     => esc_html__( 'Border Radius', 'alpha-core' ),
					'type'      => Controls_Manager::SLIDER,
					'selectors' => array(
						'.elementor-element-{{ID}} .cart select' => 'border-radius: {{SIZE}}{{UNIT}}',
					),
				)
			);

			$this->add_control(
				'heading_variations_list_style',
				array(
					'label'     => esc_html__( 'Label Swatch', 'alpha-core' ),
					'type'      => Controls_Manager::HEADING,
					'separator' => 'before',
				)
			);

			$this->start_controls_tabs( 'sp_variations_style_tabs' );

				$this->start_controls_tab(
					'sp_variations_style_normal',
					array(
						'label' => esc_html__( 'Normal', 'alpha-core' ),
					)
				);

					$this->add_control(
						'sp_variations_list_color',
						array(
							'label'     => esc_html__( 'Color', 'alpha-core' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => array(
								'.elementor-element-{{ID}} .variations button.label' => 'color: {{VALUE}}',
							),
						)
					);

					$this->add_control(
						'sp_variations_list_bg_color',
						array(
							'label'     => esc_html__( 'Background Color', 'alpha-core' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => array(
								'.elementor-element-{{ID}} .variations button.label' => 'background-color: {{VALUE}}',
							),
						)
					);

					$this->add_control(
						'sp_variations_list_border_color',
						array(
							'label'     => esc_html__( 'Border Color', 'alpha-core' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => array(
								'.elementor-element-{{ID}} .variations button.label' => 'border: 1px solid {{VALUE}}',
							),
						)
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
					'sp_variations_style_hover',
					array(
						'label' => esc_html__( 'Normal', 'alpha-core' ),
					)
				);

					$this->add_control(
						'sp_variations_list_color_hover',
						array(
							'label'     => esc_html__( 'Hover Color', 'alpha-core' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => array(
								'.elementor-element-{{ID}} .variations button.label:hover, .elementor-element-{{ID}} .variations button.label.active' => 'color: {{VALUE}}',
							),
						)
					);

					$this->add_control(
						'sp_variations_list_bg_color_hover',
						array(
							'label'     => esc_html__( 'Hover Background Color', 'alpha-core' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => array(
								'.elementor-element-{{ID}} .variations button.label:hover, .elementor-element-{{ID}} .variations button.label.active' => 'background-color: {{VALUE}}',
							),
						)
					);

					$this->add_control(
						'sp_variations_list_border_color_hover',
						array(
							'label'     => esc_html__( 'Hover Border Color', 'alpha-core' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => array(
								'.elementor-element-{{ID}} .variations button.label:hover, .elementor-element-{{ID}} .variations button.label.active' => 'border: 1px solid {{VALUE}}',
							),
						)
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				array(
					'name'     => 'sp_variations_list_typo',
					'selector' => '.elementor-element-{{ID}} .variations button.label',
				)
			);

			$this->add_control(
				'sp_variations_list_border_radius',
				array(
					'label'     => esc_html__( 'Border Radius', 'alpha-core' ),
					'type'      => Controls_Manager::SLIDER,
					'selectors' => array(
						'.elementor-element-{{ID}} .variations button.label' => 'border-radius: {{SIZE}}{{UNIT}}',
					),
				)
			);

			$this->add_control(
				'heading_variations_swatch_style',
				array(
					'label'     => esc_html__( 'Color / Image Swatch', 'alpha-core' ),
					'type'      => Controls_Manager::HEADING,
					'separator' => 'before',
				)
			);

			$this->add_control(
				'sp_variations_swatch_size',
				array(
					'label'     => esc_html__( 'Size', 'alpha-core' ),
					'type'      => Controls_Manager::SLIDER,
					'selectors' => array(
						'.elementor-element-{{ID}} .variations button:not(.label)' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}',
					),
				)
			);

			$this->add_control(
				'sp_variations_swatch_border_radius',
				array(
					'label'     => esc_html__( 'Border Radius', 'alpha-core' ),
					'type'      => Controls_Manager::SLIDER,
					'selectors' => array(
						'.elementor-element-{{ID}} .variations button:not(.label)' => 'border-radius: {{SIZE}}{{UNIT}}',
					),
				)
			);

			$this->add_control(
				'sp_variations_swatch_icon_size',
				array(
					'label'     => esc_html__( 'Active Icon Size', 'alpha-core' ),
					'type'      => Controls_Manager::SLIDER,
					'selectors' => array(
						'.elementor-element-{{ID}} .variations button:not(.label):before' => 'font-size: {{SIZE}}{{UNIT}}',
					),
				)
			);

			$this->add_control(
				'heading_reset_variations_style',
				array(
					'label'     => esc_html__( 'Reset Variations', 'alpha-core' ),
					'type'      => Controls_Manager::HEADING,
					'separator' => 'before',
				)
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				array(
					'name'     => 'sp_reset_typo',
					'selector' => '.elementor-element-{{ID}} .variations .reset_variations',
				)
			);

			$this->add_control(
				'sp_reset_margin',
				array(
					'label'     => esc_html__( 'Margin', 'alpha-core' ),
					'type'      => Controls_Manager::DIMENSIONS,
					'selectors' => array(
						'.elementor-element-{{ID}} .variations .reset_variations' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);

			$this->add_control(
				'sp_reset_padding',
				array(
					'label'     => esc_html__( 'Padding', 'alpha-core' ),
					'type'      => Controls_Manager::DIMENSIONS,
					'selectors' => array(
						'.elementor-element-{{ID}} .variations .reset_variations' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_cf_stock_style',
			array(
				'label' => esc_html__( 'Stock Status', 'alpha-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

			$this->add_control(
				'stock_spacing',
				array(
					'label'      => esc_html__( 'Spacing', 'alpha-core' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => array( 'px', 'em', 'rem' ),
					'selectors'  => array(
						'{{WRAPPER}} .stock' => 'margin-bottom: {{SIZE}}{{UNIT}}',
						'{{WRAPPER}} .single_variation_wrap .stock' => 'margin-bottom: calc({{SIZE}}{{UNIT}} - 10px)',
					),
				)
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_cf_quantity_style',
			array(
				'label' => esc_html__( 'Quantity Input', 'alpha-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

			$this->add_control(
				'spacing',
				array(
					'label'      => esc_html__( 'Spacing', 'alpha-core' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => array( 'px', 'em' ),
					'selectors'  => array(
						'body:not(.rtl) .elementor-element-{{ID}} .quantity' => 'margin-right: {{SIZE}}{{UNIT}}',
						'body.rtl .elementor-element-{{ID}} .quantity' => 'margin-left: {{SIZE}}{{UNIT}}',
					),
				)
			);

			$this->add_responsive_control(
				'sp_qty_height',
				array(
					'label'      => esc_html__( 'Height', 'alpha-core' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => array( 'px', 'em', 'rem' ),
					'selectors'  => array(
						'.elementor-element-{{ID}} .cart .quantity' => 'height: {{SIZE}}{{UNIT}}',
					),
				)
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				array(
					'name'     => 'sp_qty_typo',
					'selector' => '.elementor-element-{{ID}} .quantity',
				)
			);

			$this->add_group_control(
				Group_Control_Border::get_type(),
				array(
					'name'     => 'sp_qty_border',
					'selector' => '.elementor-element-{{ID}} .quantity, .elementor-element-{{ID}} .quantity .qty',
					'exclude'  => array( 'color' ),
				)
			);

			$this->add_control(
				'sp_qty_border_radius',
				array(
					'label'     => esc_html__( 'Border Radius', 'alpha-core' ),
					'type'      => Controls_Manager::DIMENSIONS,
					'selectors' => array(
						'.elementor-element-{{ID}} .quantity' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);

			$this->add_control(
				'sp_qty_padding',
				array(
					'label'      => esc_html__( 'Padding', 'alpha-core' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => array( 'px', 'em' ),
					'selectors'  => array(
						'.elementor-element-{{ID}} .quantity .qty' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; width: auto;',
					),
				)
			);

			$this->start_controls_tabs( 'sp_qty_style_tabs' );

			$this->start_controls_tab(
				'sp_qty_style_normal',
				array(
					'label' => esc_html__( 'Normal', 'alpha-core' ),
				)
			);

			$this->add_control(
				'sp_qty_text_color',
				array(
					'label'     => esc_html__( 'Text Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .quantity .qty' => 'color: {{VALUE}}',
					),
				)
			);

			$this->add_control(
				'sp_qty_bg_color',
				array(
					'label'     => esc_html__( 'Background Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .quantity .qty' => 'background-color: {{VALUE}}',
					),
				)
			);

			$this->add_control(
				'sp_qty_border_color',
				array(
					'label'     => esc_html__( 'Border Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .quantity .qty, .elementor-element-{{ID}} .quantity' => 'border-color: {{VALUE}}',
					),
				)
			);

			$this->end_controls_tab();

			$this->start_controls_tab(
				'sp_qty_style_focus',
				array(
					'label' => esc_html__( 'Focus', 'alpha-core' ),
				)
			);

			$this->add_control(
				'sp_qty_text_color_focus',
				array(
					'label'     => esc_html__( 'Focus Text Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .quantity .qty:focus' => 'color: {{VALUE}}',
					),
				)
			);

			$this->add_control(
				'sp_qty_bg_color_focus',
				array(
					'label'     => esc_html__( 'Focus Background Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .quantity .qty:focus' => 'background-color: {{VALUE}}',
					),
				)
			);

			$this->add_control(
				'sp_qty_border_color_focus',
				array(
					'label'     => esc_html__( 'Focus Border Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .quantity .qty:focus, .elementor-element-{{ID}} .quantity button:focus' => 'border-color: {{VALUE}}',
					),
				)
			);

			$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'section_cf_button_style',
			array(
				'label' => esc_html__( 'Button', 'alpha-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				array(
					'name'     => 'sp_btn_typo',
					'selector' => '.elementor-element-{{ID}} .cart .button',
				)
			);

			$this->add_group_control(
				Group_Control_Border::get_type(),
				array(
					'name'     => 'sp_btn_border',
					'selector' => '.elementor-element-{{ID}} .cart .button',
					'exclude'  => array( 'color' ),
				)
			);

			$this->add_control(
				'sp_btn_border_radius',
				array(
					'label'     => esc_html__( 'Border Radius', 'alpha-core' ),
					'type'      => Controls_Manager::DIMENSIONS,
					'selectors' => array(
						'.elementor-element-{{ID}} .cart .button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);

			$this->add_control(
				'sp_btn_padding',
				array(
					'label'      => esc_html__( 'Padding', 'alpha-core' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => array( 'px', 'em' ),
					'selectors'  => array(
						'.elementor-element-{{ID}} form.cart .button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);

		if ( function_exists( 'alpha_get_option' ) && alpha_get_option( 'show_buy_now_btn' ) ) {
			$this->add_control(
				'heading_cart_style',
				array(
					'label'     => esc_html__( 'Add To Cart', 'alpha-core' ),
					'type'      => Controls_Manager::HEADING,
					'separator' => 'before',
				)
			);
		}

			$this->start_controls_tabs( 'sp_btn_style_tabs' );

				$this->start_controls_tab(
					'sp_btn_style_normal',
					array(
						'label' => esc_html__( 'Normal', 'alpha-core' ),
					)
				);

					$this->add_control(
						'sp_btn_text_color',
						array(
							'label'     => esc_html__( 'Text Color', 'alpha-core' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => array(
								'.elementor-element-{{ID}} .cart .single_add_to_cart_button' => 'color: {{VALUE}}',
							),
						)
					);

					$this->add_control(
						'sp_btn_bg_color',
						array(
							'label'     => esc_html__( 'Background Color', 'alpha-core' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => array(
								'.elementor-element-{{ID}} .cart .single_add_to_cart_button' => 'background-color: {{VALUE}}',
							),
						)
					);

					$this->add_control(
						'sp_btn_border_color',
						array(
							'label'     => esc_html__( 'Border Color', 'alpha-core' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => array(
								'.elementor-element-{{ID}} .cart .single_add_to_cart_button' => 'border-color: {{VALUE}}',
							),
						)
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
					'sp_btn_style_hover',
					array(
						'label' => esc_html__( 'Hover', 'alpha-core' ),
					)
				);

					$this->add_control(
						'sp_btn_text_color_hover',
						array(
							'label'     => esc_html__( 'Hover Text Color', 'alpha-core' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => array(
								'.elementor-element-{{ID}} .cart .single_add_to_cart_button:hover' => 'color: {{VALUE}}',
							),
						)
					);

					$this->add_control(
						'sp_btn_bg_color_hover',
						array(
							'label'     => esc_html__( 'Hover Background Color', 'alpha-core' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => array(
								'.elementor-element-{{ID}} .cart .single_add_to_cart_button:hover' => 'background-color: {{VALUE}}',
							),
						)
					);

					$this->add_control(
						'sp_btn_border_color_hover',
						array(
							'label'     => esc_html__( 'Hover Border Color', 'alpha-core' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => array(
								'.elementor-element-{{ID}} .cart .single_add_to_cart_button:hover' => 'border-color: {{VALUE}}',
							),
						)
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		if ( function_exists( 'alpha_get_option' ) && alpha_get_option( 'show_buy_now_btn' ) ) {
			$this->add_control(
				'heading_buy_style',
				array(
					'label'     => esc_html__( 'Buy Now', 'alpha-core' ),
					'type'      => Controls_Manager::HEADING,
					'separator' => 'before',
				)
			);
		}

			$this->start_controls_tabs( 'sp_buy_btn_style_tabs' );

				$this->start_controls_tab(
					'sp_buy_btn_style_normal',
					array(
						'label' => esc_html__( 'Normal', 'alpha-core' ),
					)
				);

					$this->add_control(
						'sp_buy_btn_text_color',
						array(
							'label'     => esc_html__( 'Text Color', 'alpha-core' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => array(
								'.elementor-element-{{ID}} .cart .single_buy_now_button ' => 'color: {{VALUE}}',
							),
						)
					);

					$this->add_control(
						'sp_buy_btn_bg_color',
						array(
							'label'     => esc_html__( 'Background Color', 'alpha-core' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => array(
								'.elementor-element-{{ID}} .cart .single_buy_now_button ' => 'background-color: {{VALUE}}',
							),
						)
					);

					$this->add_control(
						'sp_buy_btn_border_color',
						array(
							'label'     => esc_html__( 'Border Color', 'alpha-core' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => array(
								'.elementor-element-{{ID}} .cart .single_buy_now_button ' => 'border-color: {{VALUE}}',
							),
						)
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
					'sp_buy_btn_style_hover',
					array(
						'label' => esc_html__( 'Hover', 'alpha-core' ),
					)
				);

					$this->add_control(
						'sp_buy_btn_text_color_hover',
						array(
							'label'     => esc_html__( 'Hover Text Color', 'alpha-core' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => array(
								'.elementor-element-{{ID}} .cart .single_buy_now_button:hover' => 'color: {{VALUE}}',
							),
						)
					);

					$this->add_control(
						'sp_buy_btn_bg_color_hover',
						array(
							'label'     => esc_html__( 'Hover Background Color', 'alpha-core' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => array(
								'.elementor-element-{{ID}} .cart .single_buy_now_button:hover' => 'background-color: {{VALUE}}',
							),
						)
					);

					$this->add_control(
						'sp_buy_btn_border_color_hover',
						array(
							'label'     => esc_html__( 'Hover Border Color', 'alpha-core' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => array(
								'.elementor-element-{{ID}} .cart .single_buy_now_button:hover' => 'border-color: {{VALUE}}',
							),
						)
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();
	}

	protected function render() {
		/**
		 * Filters post products in single product builder
		 *
		 * @since 1.0
		 */
		if ( apply_filters( 'alpha_single_product_builder_set_preview', false ) ) {
			$settings = $this->get_settings_for_display();
			add_filter( 'alpha_single_product_sticky_cart_enabled', 'yes' == $settings['sp_sticky'] ? '__return_true' : '__return_false' );

			global $alpha_stock_progress;
			$alpha_stock_progress = 'yes' == $settings['sp_stock_progressbar'];

			if ( $alpha_stock_progress ) {
				wp_enqueue_style( 'alpha-progressbar' );
				wp_enqueue_script( 'alpha-progress-bar' );
			}

			woocommerce_template_single_add_to_cart();

			unset( $GLOBALS['alpha_stock_progress'] );

			remove_filter( 'alpha_single_product_sticky_cart_enabled', 'yes' == $settings['sp_sticky'] ? '__return_true' : '__return_false' );
			do_action( 'alpha_single_product_builder_unset_preview' );
		}
	}
}
