<?php
defined( 'ABSPATH' ) || die;

/**
 * Alpha Elementor Shop Pagination Widget
 *
 * @author     Andon
 * @package    Alpha Core FrameWork
 * @subpackage Core
 * @since      4.1
 */

use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Color;
use Elementor\Group_Control_Typography;

class Alpha_Shop_Pagination_Elementor_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return ALPHA_NAME . '_shop_widget_pagination';
	}

	public function get_title() {
		return esc_html__( 'Pagination', 'alpha-core' );
	}

	public function get_categories() {
		return array( 'alpha_shop_widget' );
	}

	public function get_keywords() {
		return array( 'pagination', 'shop', 'woocommerce' );
	}

	public function get_icon() {
		return 'alpha-elementor-widget-icon eicon-number-field';
	}

	public function has_widget_inner_wrapper(): bool {
		return ! Plugin::$instance->experiments->is_feature_active( 'e_optimized_markup' );
	}

	protected function register_controls() {

		$left  = is_rtl() ? 'right' : 'left';
		$right = 'left' == $left ? 'right' : 'left';

		$this->start_controls_section(
			'section_result',
			array(
				'label' => esc_html__( 'Styles', 'alpha-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
			$this->add_control(
				'page_number_heading',
				array(
					'label' => esc_html__( 'Numbers', 'alpha-pro' ),
					'type'  => Controls_Manager::HEADING,
				)
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				array(
					'name'     => 'text_typography',
					'selector' => '.elementor-element-{{ID}} .page-numbers:not(.next, .prev)',
				)
			);

			$this->add_responsive_control(
				'item_space',
				array(
					'label'      => esc_html__( 'Space Between', 'alpha-core' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => array( 'px', '%', 'rem' ),
					'range'      => array(
						'px' => array(
							'step' => 1,
							'min'  => 0,
							'max'  => 20,
						),
					),
					'selectors'  => array(
						'.elementor-element-{{ID}} .page-numbers:not(:last-child)' => "margin-{$right}: {{SIZE}}{{UNIT}}",
					),
				)
			);

			$this->add_control(
				'page_numbers_bw',
				array(
					'label'      => esc_html__( 'Border Width', 'alpha-pro' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => array(
						'px',
						'%',
						'em',
					),
					'selectors'  => array(
						'.elementor-element-{{ID}} .page-numbers:not(.prev, .next)' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);

			$this->add_control(
				'page_numbers_br',
				array(
					'label'      => esc_html__( 'Border Radius', 'alpha-pro' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => array(
						'px',
						'%',
						'em',
					),
					'selectors'  => array(
						'.elementor-element-{{ID}} .page-numbers:not(.prev, .next)' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);

			$this->start_controls_tabs( 'tabs_page_numbers' );

			$this->start_controls_tab(
				'tab_btn_normal',
				array(
					'label' => esc_html__( 'Normal', 'alpha-core' ),
				)
			);

			$this->add_control(
				'btn_color',
				array(
					'label'     => esc_html__( 'Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .page-numbers:not(.prev, .next)' => 'color: {{VALUE}};',
					),
				)
			);

			$this->add_control(
				'btn_back_color',
				array(
					'label'     => esc_html__( 'Background Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .page-numbers:not(.prev, .next)' => 'background-color: {{VALUE}};',
					),
				)
			);

			$this->add_control(
				'btn_border_color',
				array(
					'label'     => esc_html__( 'Border Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .page-numbers:not(.prev, .next)' => 'border-color: {{VALUE}};',
					),
				)
			);

			$this->end_controls_tab();

			$this->start_controls_tab(
				'tab_btn_hover',
				array(
					'label' => esc_html__( 'Hover/Active', 'alpha-core' ),
				)
			);

			$this->add_control(
				'btn_color_hover',
				array(
					'label'     => esc_html__( 'Active Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .page-numbers:not(.prev, .next):hover, .elementor-element-{{ID}} .page-numbers.current' => 'color: {{VALUE}};',
					),
				)
			);

			$this->add_control(
				'btn_back_color_hover',
				array(
					'label'     => esc_html__( 'Active Background Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .page-numbers:not(.prev, .next):hover, .elementor-element-{{ID}} .page-numbers.current' => 'background-color: {{VALUE}};',
					),
				)
			);

			$this->add_control(
				'btn_border_color_hover',
				array(
					'label'     => esc_html__( 'Active Border Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .page-numbers:not(.prev, .next):hover, .elementor-element-{{ID}} .page-numbers.current' => 'border-color: {{VALUE}};',
					),
				)
			);

			$this->end_controls_tab();

			$this->end_controls_tabs();

			$this->add_control(
				'page_nav_heading',
				array(
					'label'     => esc_html__( 'Nav Icons', 'alpha-core' ),
					'type'      => Controls_Manager::HEADING,
					'separator' => 'before',
				)
			);

			$this->add_responsive_control(
				'page_nav_size',
				array(
					'label'      => esc_html__( 'Size', 'alpha-pro' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => array( 'px', '%', 'rem' ),
					'selectors'  => array(
						'.elementor-element-{{ID}} .pagination .prev, .elementor-element-{{ID}} .pagination .next' => 'font-size: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->add_control(
				'page_nav_bw',
				array(
					'label'      => esc_html__( 'Border Width', 'alpha-pro' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => array(
						'px',
						'%',
						'em',
					),
					'selectors'  => array(
						'.elementor-element-{{ID}} .pagination .prev, .elementor-element-{{ID}} .pagination .next' => 'border: 0px solid; border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);

			$this->add_control(
				'page_nav_br',
				array(
					'label'      => esc_html__( 'Border Radius', 'alpha-pro' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => array(
						'px',
						'%',
						'em',
					),
					'selectors'  => array(
						'.elementor-element-{{ID}} .pagination .prev, .elementor-element-{{ID}} .pagination .next' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);

			$this->start_controls_tabs( 'tabs_page_navs' );

			$this->start_controls_tab(
				'tab_nav_normal',
				array(
					'label' => esc_html__( 'Normal', 'alpha-pro' ),
				)
			);

			$this->add_control(
				'page_nav_color',
				array(
					'label'     => esc_html__( 'Color', 'alpha-pro' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .pagination .prev, {{WRAPPER}} .pagination .next' => 'color: {{VALUE}};',
					),
				)
			);

			$this->add_control(
				'page_nav_bg_color',
				array(
					'label'     => esc_html__( 'Background Color', 'alpha-pro' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .pagination .prev, {{WRAPPER}} .pagination .next' => 'background-color: {{VALUE}};',
					),
				)
			);

			$this->add_control(
				'page_nav_bd_color',
				array(
					'label'     => esc_html__( 'Border Color', 'alpha-pro' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .pagination .prev, {{WRAPPER}} .pagination .next' => 'border-color: {{VALUE}};',
					),
				)
			);

			$this->end_controls_tab();

			$this->start_controls_tab(
				'tab_nav_hover',
				array(
					'label' => esc_html__( 'Hover', 'alpha-pro' ),
				)
			);

			$this->add_control(
				'page_nav_color_hover',
				array(
					'label'     => esc_html__( 'Hover Color', 'alpha-pro' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .pagination .prev:hover, {{WRAPPER}} .pagination .next:hover' => 'color: {{VALUE}};',
					),
				)
			);

			$this->add_control(
				'page_nav_bg_color_hover',
				array(
					'label'     => esc_html__( 'Hover Background Color', 'alpha-pro' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .pagination .prev:hover, {{WRAPPER}} .pagination .next:hover' => 'background-color: {{VALUE}};',
					),
				)
			);

			$this->add_control(
				'page_nav_bd_color_hover',
				array(
					'label'     => esc_html__( 'Hover Border Color', 'alpha-pro' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .pagination .prev:hover, {{WRAPPER}} .pagination .next:hover' => 'border-color: {{VALUE}};',
					),
				)
			);

			$this->end_controls_tab();

			$this->start_controls_tab(
				'tab_nav_disabled',
				array(
					'label' => esc_html__( 'Disabled', 'alpha-core' ),
				)
			);

			$this->add_control(
				'page_nav_color_disabled',
				array(
					'label'     => esc_html__( 'Disabled Color', 'alpha-pro' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .pagination .disabled' => 'color: {{VALUE}};',
					),
				)
			);

			$this->add_control(
				'page_nav_bg_color_disabled',
				array(
					'label'     => esc_html__( 'Disabled Background Color', 'alpha-pro' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .pagination .disabled' => 'background-color: {{VALUE}};',
					),
				)
			);

			$this->add_control(
				'page_nav_bd_color_disabled',
				array(
					'label'     => esc_html__( 'Disabled Border Color', 'alpha-pro' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .pagination .disabled' => 'border-color: {{VALUE}};',
					),
				)
			);

			$this->end_controls_tab();

			$this->end_controls_tabs();

			$this->add_responsive_control(
				'pagination_align',
				array(
					'label'       => esc_html__( 'Horizontal Align', 'alpha-core' ),
					'type'        => Controls_Manager::CHOOSE,
					'description' => esc_html__( 'Control the horizontal align of pagination.', 'alpha-core' ),
					'options'     => array(
						'flex-start' => array(
							'title' => esc_html__( 'Left', 'alpha-core' ),
							'icon'  => 'eicon-text-align-left',
						),
						'center'     => array(
							'title' => esc_html__( 'Center', 'alpha-core' ),
							'icon'  => 'eicon-text-align-center',
						),
						'flex-end'   => array(
							'title' => esc_html__( 'Right', 'alpha-core' ),
							'icon'  => 'eicon-text-align-right',
						),
					),
					'separator'   => 'before',
					'selectors'   => array(
						'.elementor-element-{{ID}} .pagination' => 'justify-content: {{VALUE}}',
					),
				)
			);

			$this->add_responsive_control(
				'pagination_margin',
				array(
					'label'      => esc_html__( 'Margin', 'alpha-core' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => array(
						'px',
						'%',
						'rem',
						'em',
					),
					'selectors'  => array(
						'{{WRAPPER}} .pagination' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);

		$this->end_controls_section();

	}

	protected function render() {
		$atts = $this->get_settings_for_display();

		global $wp_query;

		if ( apply_filters( 'alpha_shop_builder_set_preview', false ) ) {
			if ( 1 != $wp_query->max_num_pages ) {
				woocommerce_pagination();
			} else {
				echo '<div class="pagination d-none"></div>';
			}
		}
		do_action( 'alpha_shop_builder_unset_preview' );
	}

	protected function content_template() {}
}
