<?php
defined( 'ABSPATH' ) || die;

/**
 * Alpha Contact Form Widget
 *
 * Alpha Widget to display contact form with cf7.
 *
 * @author     D-THEMES
 * @package    WP Alpha Core FrameWork
 * @subpackage Core
 * @since      1.3.0
 */

use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Icons_Manager;
use Elementor\Repeater;
use Elementor\Alpha_Controls_Manager;

class Alpha_Contact_Form_Elementor_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return ALPHA_NAME . '_widget_contact_form';
	}

	public function get_title() {
		return __( 'Contact Form 7', 'alpha-core' );
	}

	public function get_categories() {
		return array( 'alpha_widget' );
	}

	public function get_keywords() {
		return array( 'forms', 'field', 'button', 'submit', 'mail', 'wpform', 'newsletter' );
	}

	public function get_icon() {
		return 'alpha-elementor-widget-icon eicon-form-horizontal';
	}

	protected function is_dynamic_content(): bool {
		return true;
	}

	public function has_widget_inner_wrapper(): bool {
		return ! Plugin::$instance->experiments->is_feature_active( 'e_optimized_markup' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_contact_form',
			array(
				'label' => __( 'Contact Form', 'alpha-core' ),
			)
		);

		$this->add_control(
			'cf7_form',
			array(
				'type'        => Alpha_Controls_Manager::AJAXSELECT2,
				'label'       => __( 'Contact Forms', 'alpha-core' ),
				'options'     => 'wpcf7_contact_form',
				'label_block' => true,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'tg',
				'label'    => __( 'Global Typography', 'alpha-core' ),
				'selector' => '.elementor-element-{{ID}}',
			)
		);

		$this->add_responsive_control(
			'falign',
			array(
				'label'     => esc_html__( 'Alignment', 'alpha-core' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'alpha-core' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'alpha-core' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'alpha-core' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'selectors' => array(
					'.elementor-element-{{ID}} .wpcf7-form' => '--alpha-form-align: {{VALUE}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_contact_form_fields',
			array(
				'label' => __( 'Form Fields', 'alpha-core' ),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'lbl_tg',
				'label'    => __( 'Label Typography', 'alpha-core' ),
				'selector' => '.elementor-element-{{ID}} label',
			)
		);

		$this->add_control(
			'lbl_mb',
			array(
				'type'       => Controls_Manager::SLIDER,
				'label'      => __( 'Label Bottom Spacing', 'alpha-core' ),
				'range'      => array(
					'px'  => array(
						'step' => 1,
						'min'  => 0,
						'max'  => 50,
					),
					'em'  => array(
						'step' => 0.1,
						'min'  => 0,
						'max'  => 5,
					),
					'rem' => array(
						'step' => 0.1,
						'min'  => 0,
						'max'  => 5,
					),
				),
				'default'    => array(
					'unit' => 'px',
				),
				'size_units' => array(
					'px',
					'em',
					'rem',
				),
				'selectors'  => array(
					'.elementor-element-{{ID}} .wpcf7-form' => '--alpha-label-bottom-spacing: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'ih',
			array(
				'type'       => Controls_Manager::SLIDER,
				'label'      => __( 'The Height of input and select box', 'alpha-core' ),
				'range'      => array(
					'px'  => array(
						'step' => 1,
						'min'  => 0,
						'max'  => 100,
					),
					'em'  => array(
						'step' => 0.1,
						'min'  => 0,
						'max'  => 10,
					),
					'rem' => array(
						'step' => 0.1,
						'min'  => 0,
						'max'  => 10,
					),
				),
				'default'    => array(
					'unit' => 'px',
				),
				'size_units' => array(
					'px',
					'em',
					'rem',
				),
				'selectors'  => array(
					'.elementor-element-{{ID}} .wpcf7-form' => '--alpha-form-field-height: {{SIZE}}{{UNIT}}; min-height: 0;',
				),
			)
		);

		$this->add_responsive_control(
			'tah',
			array(
				'type'       => Controls_Manager::SLIDER,
				'label'      => __( 'The Height of textarea', 'alpha-core' ),
				'range'      => array(
					'px'  => array(
						'step' => 1,
						'min'  => 0,
						'max'  => 400,
					),
					'em'  => array(
						'step' => 0.1,
						'min'  => 0,
						'max'  => 40,
					),
					'rem' => array(
						'step' => 0.1,
						'min'  => 0,
						'max'  => 40,
					),
				),
				'default'    => array(
					'unit' => 'px',
				),
				'size_units' => array(
					'px',
					'em',
					'rem',
				),
				'selectors'  => array(
					'.elementor-element-{{ID}} .wpcf7-form' => '--alpha-form-textarea-height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'fs',
			array(
				'type'        => Controls_Manager::SLIDER,
				'label'       => __( 'Field Font Size', 'alpha-core' ),
				'description' => __( 'Inputs the font size of input, select and textarea fields.', 'alpha-core' ),
				'range'       => array(
					'px'  => array(
						'step' => 1,
						'min'  => 0,
						'max'  => 40,
					),
					'em'  => array(
						'step' => 0.1,
						'min'  => 0,
						'max'  => 5,
					),
					'rem' => array(
						'step' => 0.1,
						'min'  => 0,
						'max'  => 5,
					),
				),
				'default'     => array(
					'unit' => 'px',
				),
				'size_units'  => array(
					'px',
					'em',
					'rem',
				),
				'selectors'   => array(
					'.elementor-element-{{ID}} .wpcf7-form' => '--alpha-form-field-font-size: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'clr',
			array(
				'type'        => Controls_Manager::COLOR,
				'label'       => __( 'Field Color', 'alpha-core' ),
				'description' => __( 'Controls the color of the form and form fields.', 'alpha-core' ),
				'selectors'   => array(
					'.elementor-element-{{ID}} .wpcf7' => '--alpha-form-field-color: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'ph_trans',
			array(
				'label'       => esc_html__( 'Placeholder Transparency', 'alpha-core' ),
				'description' => esc_html__( 'Input transparency of placeholder text.', 'alpha-core' ),
				'type'        => Controls_Manager::NUMBER,
				'min'         => 0,
				'max'         => 1,
				'step'        => 0.1,
				'selectors'   => array(
					'.elementor-element-{{ID}} .wpcf7' => '--alpha-form-field-placeholder: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'field_bgc',
			array(
				'type'        => Controls_Manager::COLOR,
				'label'       => __( 'Form Field Background Color', 'alpha-core' ),
				'description' => __( 'Controls the background color of form fields such as input and select boxes.', 'alpha-core' ),
				'selectors'   => array(
					'.elementor-element-{{ID}} .wpcf7' => '--alpha-form-field-bg-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'field_bw',
			array(
				'type'        => Controls_Manager::DIMENSIONS,
				'label'       => __( 'Form Field Border Width (px)', 'alpha-core' ),
				'description' => __( 'Controls the border size of the form fields such as input and select boxes.', 'alpha-core' ),
				'size_units'  => array( 'px' ),
				'selectors'   => array(
					'.elementor-element-{{ID}} .wpcf7' => '--alpha-form-field-border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'field_bc',
			array(
				'type'        => Controls_Manager::COLOR,
				'label'       => __( 'Form Field Border Color', 'alpha-core' ),
				'description' => __( 'Controls the border color of form fields such as input and select boxes.', 'alpha-core' ),
				'selectors'   => array(
					'.elementor-element-{{ID}} .wpcf7' => '--alpha-form-field-border-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'field_bcf',
			array(
				'type'        => Controls_Manager::COLOR,
				'label'       => __( 'Focus Form Field Border Color', 'alpha-core' ),
				'description' => __( 'Controls the border color of form fields such as input and select boxes on focus status.', 'alpha-core' ),
				'selectors'   => array(
					'.elementor-element-{{ID}} .wpcf7' => '--alpha-form-field-focus-border-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'field_bcin',
			array(
				'type'        => Controls_Manager::COLOR,
				'label'       => __( 'Invalid Form Field Border Color', 'alpha-core' ),
				'description' => __( 'Controls the border color of form fields such as input and select boxes on invalid status.', 'alpha-core' ),
				'selectors'   => array(
					'.elementor-element-{{ID}} .wpcf7-form' => '--alpha-form-field-invalid-border-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'br',
			array(
				'type'        => Controls_Manager::DIMENSIONS,
				'label'       => __( 'Form Field Border Radius (px)', 'alpha-core' ),
				'description' => __( 'Controls the border radius of form fields such as input, select boxes and buttons.', 'alpha-core' ),
				'selectors'   => array(
					'.elementor-element-{{ID}} .wpcf7' => '--alpha-border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'size_units'  => array( 'px' ),
			)
		);

		$this->add_responsive_control(
			'form_space',
			array(
				'type'       => Controls_Manager::DIMENSIONS,
				'label'      => __( 'Form Field Padding', 'alpha-core' ),
				'selectors'  => array(
					'.elementor-element-{{ID}} .wpcf7' => '--alpha-form-field-padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'size_units' => array( 'px', 'rem' ),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_contact_form_buttons',
			array(
				'label' => __( 'Buttons', 'alpha-core' ),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'btn_tg',
				'label'    => __( 'Typography', 'alpha-core' ),
				'selector' => '.elementor-element-{{ID}} button.wpcf7-form-control, .elementor-element-{{ID}} .wpcf7 .btn, .elementor-element-{{ID}} .wpcf7 input[type="submit"], .elementor-element-{{ID}} input[type="button"]',
			)
		);

		$this->add_responsive_control(
			'bh',
			array(
				'type'       => Controls_Manager::SLIDER,
				'label'      => __( 'The Height of Buttons', 'alpha-core' ),
				'range'      => array(
					'px'  => array(
						'step' => 1,
						'min'  => 0,
						'max'  => 100,
					),
					'em'  => array(
						'step' => 0.1,
						'min'  => 0,
						'max'  => 10,
					),
					'rem' => array(
						'step' => 0.1,
						'min'  => 0,
						'max'  => 10,
					),
				),
				'default'    => array(
					'unit' => 'px',
				),
				'size_units' => array(
					'px',
					'em',
					'rem',
				),
				'selectors'  => array(
					'.elementor-element-{{ID}} button.wpcf7-form-control, .elementor-element-{{ID}} .wpcf7 .btn, .elementor-element-{{ID}} .wpcf7 input[type="submit"], .elementor-element-{{ID}} .wpcf7 input[type="button"]' => 'height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'btn_pd',
			array(
				'type'       => Controls_Manager::DIMENSIONS,
				'label'      => __( 'Padding', 'alpha-core' ),
				'selectors'  => array(
					'.elementor-element-{{ID}} button.wpcf7-form-control, .elementor-element-{{ID}} .wpcf7 .btn, .elementor-element-{{ID}} .wpcf7 input[type="submit"], .elementor-element-{{ID}} .wpcf7 input[type="button"]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'size_units' => array( 'px', 'em', 'rem' ),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'btn_bd',
				'selector' => '.elementor-element-{{ID}} button.wpcf7-form-control, .elementor-element-{{ID}} .wpcf7 .btn, .elementor-element-{{ID}} .wpcf7 input[type="submit"], .elementor-element-{{ID}} .wpcf7 input[type="button"]',
				'exclude'  => array(
					'color',
				),
			)
		);

		$this->add_control(
			'btn_br',
			array(
				'type'       => Controls_Manager::DIMENSIONS,
				'label'      => __( 'Border Radius (px)', 'alpha-core' ),
				'selectors'  => array(
					'.elementor-element-{{ID}} button.wpcf7-form-control, .elementor-element-{{ID}} .wpcf7 .btn, .elementor-element-{{ID}} .wpcf7 input[type="submit"], .elementor-element-{{ID}} .wpcf7 input[type="button"]' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'size_units' => array( 'px' ),
			)
		);

		$this->start_controls_tabs( 'tabs_btn_style' );

		$this->start_controls_tab(
			'tabs_btn_normal',
			array(
				'label' => __( 'Normal', 'alpha-core' ),
			)
		);

		$this->add_control(
			'btn_clr',
			array(
				'label'     => __( 'Color', 'alpha-core' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'.elementor-element-{{ID}} button.wpcf7-form-control, .elementor-element-{{ID}} .wpcf7 .btn, .elementor-element-{{ID}} .wpcf7 input[type="submit"], .elementor-element-{{ID}} .wpcf7 input[type="button"]' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'btn_bgc',
			array(
				'label'     => __( 'Background Color', 'alpha-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'.elementor-element-{{ID}} button.wpcf7-form-control, .elementor-element-{{ID}} .wpcf7 .btn, .elementor-element-{{ID}} .wpcf7 input[type="submit"], .elementor-element-{{ID}} .wpcf7 input[type="button"]' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'btn_bc',
			array(
				'label'     => __( 'Border Color', 'alpha-core' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'.elementor-element-{{ID}} button.wpcf7-form-control, .elementor-element-{{ID}} .wpcf7 .btn, .elementor-element-{{ID}} .wpcf7 input[type="submit"], .elementor-element-{{ID}} .wpcf7 input[type="button"]' => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_btn_hover',
			array(
				'label' => __( 'Hover', 'alpha-core' ),
			)
		);

		$this->add_control(
			'btn_hover_clr',
			array(
				'label'     => __( 'Hover Color', 'alpha-core' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'.elementor-element-{{ID}} button.wpcf7-form-control:hover, .elementor-element-{{ID}} button.wpcf7-form-control:focus, .elementor-element-{{ID}} .wpcf7 .btn:hover, .elementor-element-{{ID}} .wpcf7 .btn:focus, .elementor-element-{{ID}} .wpcf7 input[type="submit"]:hover, .elementor-element-{{ID}} .wpcf7 input[type="submit"]:focus, .elementor-element-{{ID}} .wpcf7 input[type="button"]:hover, .elementor-element-{{ID}} .wpcf7 input[type="button"]:focus' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'btn_hover_bgc',
			array(
				'label'     => __( 'Hover Background Color', 'alpha-core' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'.elementor-element-{{ID}} button:not(.btn-bg-hover-effect):hover, .elementor-element-{{ID}} button:not(.btn-bg-hover-effect):focus, .elementor-element-{{ID}} .btn:not(.btn-bg-hover-effect):hover, .elementor-element-{{ID}} .btn:not(.btn-bg-hover-effect):focus, .elementor-element-{{ID}} .wpcf7 input[type="submit"]:hover, .elementor-element-{{ID}} .wpcf7 input[type="submit"]:focus, .elementor-element-{{ID}} .wpcf7 input[type="button"]:hover, .elementor-element-{{ID}} .wpcf7 input[type="button"]:focus, .elementor-element-{{ID}} .btn.btn-bg-hover-effect:before' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'btn_hover_bc',
			array(
				'label'     => __( 'Hover Border Color', 'alpha-core' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'.elementor-element-{{ID}} button.wpcf7-form-control:hover, .elementor-element-{{ID}} button.wpcf7-form-control:focus, .elementor-element-{{ID}} .wpcf7 .btn:hover, .elementor-element-{{ID}} .wpcf7 .btn:focus, .elementor-element-{{ID}} .wpcf7 input[type="submit"]:hover, .elementor-element-{{ID}} .wpcf7 input[type="submit"]:focus, .elementor-element-{{ID}} .wpcf7 input[type="button"]:hover, .elementor-element-{{ID}} .wpcf7 input[type="button"]:focus' => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'section_contact_form_messages',
			array(
				'label' => __( 'Messages', 'alpha-core' ),
			)
		);

		$this->add_control(
			'error_heading',
			array(
				'label' => __( 'Error Tips', 'alpha-core' ),
				'type'  => Controls_Manager::HEADING,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'error_tg',
				'label'    => __( 'Typography', 'alpha-core' ),
				'selector' => '.elementor-element-{{ID}} .wpcf7-not-valid-tip',
			)
		);

		$this->add_control(
			'error_clr',
			array(
				'label'     => __( 'Color', 'alpha-core' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'.elementor-element-{{ID}} .wpcf7-not-valid-tip' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'msg_heading',
			array(
				'label'     => __( 'Response Message', 'alpha-core' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'msg_tg',
				'label'    => __( 'Typography', 'alpha-core' ),
				'selector' => '.elementor-element-{{ID}} form .wpcf7-response-output',
			)
		);

		$this->add_control(
			'msg_clr',
			array(
				'label'     => __( 'Text Color', 'alpha-core' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'.elementor-element-{{ID}} form.wpcf7-form .wpcf7-response-output' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'msg_bgc',
			array(
				'label'     => __( 'Background Color', 'alpha-core' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'.elementor-element-{{ID}} form.wpcf7-form .wpcf7-response-output' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'msg_bd',
				'selector' => '.elementor-element-{{ID}} form.wpcf7-form .wpcf7-response-output',
			)
		);

		$this->end_controls_section();
	}

	protected function render() {
		$atts = $this->get_settings_for_display();

		require alpha_core_e_templates_path( 'widgets/contact-form/render-contact-form-elementor' );
	}
}
