<?php
/**
 * Core Framework Shortcodes
 *
 * @author     D-THEMES
 * @package    WP Alpha Core FrameWork
 * @subpackage Core
 * @version    1.0
 */

add_shortcode( ALPHA_NAME . '_year', 'alpha_shortcode_year' );
add_shortcode( ALPHA_NAME . '_posts', 'alpha_shortcode_posts' );
add_shortcode( ALPHA_NAME . '_block', 'alpha_shortcode_block' );
add_shortcode( ALPHA_NAME . '_menu', 'alpha_shortcode_menu' );
add_shortcode( ALPHA_NAME . '_breadcrumb', 'alpha_shortcode_breadcrumb' );
add_shortcode( ALPHA_NAME . '_filter', 'alpha_shortcode_filter' );

if ( class_exists( 'WooCommerce' ) ) {
	add_shortcode( ALPHA_NAME . '_products', 'alpha_shortcode_product' );
	add_shortcode( ALPHA_NAME . '_product_category', 'alpha_shortcode_product_category' );
	add_shortcode( ALPHA_NAME . '_vendors', 'alpha_shorcode_vendors' );
	add_shortcode( ALPHA_NAME . '_linked_products', 'alpha_shortcode_linked_product' );
}

function alpha_shortcode_year() {
	return date( 'Y' );
}

function alpha_shortcode_product( $atts, $content = null ) {
	ob_start();
	require alpha_core_e_templates_path( 'widgets/products/render-products' );
	return ob_get_clean();
}

function alpha_shortcode_product_category( $atts, $content = null ) {
	ob_start();
	require alpha_core_e_templates_path( 'widgets/categories/render-categories-elementor' );
	return ob_get_clean();
}

function alpha_shortcode_posts( $atts, $content = null ) {
	ob_start();
	require alpha_core_e_templates_path( 'widgets/posts/render-posts' );
	return ob_get_clean();
}


function alpha_shortcode_block( $atts, $content = null ) {
	ob_start();
	require alpha_core_e_templates_path( 'widgets/block/render-block' );
	return ob_get_clean();
}


function alpha_shortcode_menu( $atts, $content = null ) {
	ob_start();
	require alpha_core_e_templates_path( 'widgets/menu/render-menu' );
	return ob_get_clean();
}


function alpha_shortcode_linked_product( $atts, $content = null ) {
	ob_start();
	/**
	 * Filters post products in single product builder.
	 *
	 * @since 1.0
	 */
	if ( apply_filters( 'alpha_single_product_builder_set_preview', false ) ) {
		require alpha_core_e_templates_path( 'widgets/products/render-products' );
		do_action( 'alpha_single_product_builder_unset_preview' );
	}
	return ob_get_clean();
}

function alpha_shortcode_breadcrumb( $atts, $content = null ) {
	ob_start();
	require alpha_core_e_templates_path( 'widgets/breadcrumb/render-breadcrumb' );
	return ob_get_clean();
}


function alpha_shortcode_filter( $atts, $content = null ) {
	ob_start();
	require alpha_core_e_templates_path( 'widgets/filter/render-filter' );
	return ob_get_clean();
}

function alpha_shortcode_vendors( $atts, $content = null ) {
	ob_start();
	require alpha_core_e_templates_path( 'widgets/vendor/render-vendor' );
	return ob_get_clean();
}
