/**
 * Post Type Builder - WooCommerce Links
 * 
 * @since 2.3.0
 */
import AlphaStyleOptionsControl, { alphaGenerateStyleOptionsCSS } from '../../../plugins/gutenberg/assets/controls/style-options';
import AlphaTypographyControl, { alphaGenerateTypographyCSS } from '../../../plugins/gutenberg/assets/controls/typography';
import { alphaAddHelperClasses } from '../../../plugins/gutenberg/assets/controls/editor-extra-classes';

(function (wpI18n, wpBlocks, wpBlockEditor, wpComponents) {
    "use strict";

    const __ = wpI18n.__,
        registerBlockType = wpBlocks.registerBlockType,
        InspectorControls = wpBlockEditor.InspectorControls,
        SelectControl = wpComponents.SelectControl,
        TextControl = wpComponents.TextControl,
        RangeControl = wpComponents.RangeControl,
        ToggleControl = wpComponents.ToggleControl,
        UnitControl = wp.components.__experimentalUnitControl,
        Disabled = wpComponents.Disabled,
        PanelBody = wpComponents.PanelBody,
        useState = wp.element.useState,
        useEffect = wp.element.useEffect,
        ServerSideRender = wp.serverSideRender;

    const AlphaTBWooButtons = function ({ attributes, setAttributes, name, clientId }) {

        const content_type = document.getElementById('content_type').value;
        const [productAttributes, setProductAttributes] = useState([{ 'label': __('Select an attribute', 'alpha-core'), value: '' }]);
        const [firstRenderForClone, setRenderClone] = useState(false);

        useEffect(
            () => {
                wp.apiFetch({ path: '/ajaxselect2/v1/post_type_alpha' }).then(function (obj) {
                    if (obj && obj.results) {
                        let attributeOptions = [{ 'label': __('Select an attribute', 'alpha-core'), value: '' }];
                        Object.keys(obj.results).forEach(function (key) {
                            attributeOptions.push({ label: obj.results[key], value: key });
                        });
                        setProductAttributes(attributeOptions);
                    }
                });

                if (!attributes.el_class || -1 !== alpha_tb_ids.indexOf(attributes.el_class)) { // new or just cloned
                    let new_cls = 'alpha-tb-woo-buttons-' + Math.ceil(Math.random() * 10000);
                    attributes.el_class = new_cls;
                    setAttributes({ el_class: new_cls });
                }
                setRenderClone(true);
                alpha_tb_ids.push(attributes.el_class);

                return () => {
                    let arr_index = alpha_tb_ids.indexOf(attributes.el_class);
                    if (-1 !== arr_index) {
                        alpha_tb_ids.splice(arr_index, 1);
                    }
                }
            },
            [],
        );

        let style_options = {};
        if (typeof attributes.style_options != 'undefined') {
            Object.keys(attributes.style_options).forEach(function (key) {
                if (typeof attributes.style_options[key] == 'object') {
                    style_options[key] = Object.assign({}, attributes.style_options[key]);
                } else {
                    style_options[key] = attributes.style_options[key];
                }
            });
        }

        let content_type_value,
            attrs = Object.assign({}, { link_source: attributes.link_source, show_quantity_input: attributes.show_quantity_input, hide_title: attributes.hide_title, icon_cls: attributes.icon_cls, icon_pos: attributes.icon_pos, font_settings: attributes.font_settings, el_class: attributes.el_class, className: attributes.className, style_options: style_options, ...style_options });
        if (content_type) {
            attrs.content_type = content_type;
            content_type_value = document.getElementById('content_type_' + content_type);
            if (content_type_value) {
                content_type_value = content_type_value.value;
                attrs.content_type_value = content_type_value;
            }
        }

        let internalStyle = '',
            font_settings = Object.assign({}, attributes.font_settings);

        let selectorCls;
        if (attributes.el_class) {
            selectorCls = 'editor-styles-wrapper .' + attributes.el_class;
        }

        if (attributes.font_settings) {
            let fontAtts = attributes.font_settings;

            internalStyle += alphaGenerateTypographyCSS(fontAtts, selectorCls);
        }

        if ((attrs.icon_cls || attributes.icon_cls_variable) && 'wishlist' != attributes.link_source) {
            if (attributes.st_icon_fs) {
                internalStyle += '.' + selectorCls + ' i{font-size:' + attributes.st_icon_fs + '}';
            }
            if (attributes.st_spacing) {
                if ('right' === attributes.icon_pos) {
                    internalStyle += '.' + selectorCls + ' i{margin-left:' + attributes.st_spacing + '}';
                } else {
                    internalStyle += '.' + selectorCls + ' i{margin-right:' + attributes.st_spacing + '}';
                }
            }
        }

        // add helper classes to parent block element
        if (attributes.className) {
            alphaAddHelperClasses(attributes.className, clientId);
        }
        let icon_cls_ex = 'w-icon-cart';
        if ('compare' === attributes.link_source) {
            icon_cls_ex = 'w-icon-compare';
        } else if ('quickview' === attributes.link_source) {
            icon_cls_ex = 'w-icon-search';
        }

        return (
            <>
                <InspectorControls key="inspector">
                    <PanelBody title={__('General', 'alpha-core')}>
                        <SelectControl
                            label={__('Link Source', 'alpha-core')}
                            value={attributes.link_source}
                            options={[{ 'label': __('Select...', 'alpha-core'), 'value': '' }, { 'label': __('Add to cart', 'alpha-core'), 'value': 'cart' }, { 'label': __('Add to wishlist', 'alpha-core'), 'value': 'wishlist' }, { 'label': __('Compare', 'alpha-core'), 'value': 'compare' }, { 'label': __('Quick View', 'alpha'), 'value': 'quickview' }, { 'label': __('Image / Color Swatch', 'alpha-core'), 'value': 'swatch' }]}
                            onChange={(value) => { setAttributes({ link_source: value }); }}
                        />
                        {'cart' == attributes.link_source && (
                            <ToggleControl
                                label={__('Show Quantity Input', 'alpha-core')}
                                checked={attributes.show_quantity_input}
                                onChange={(value) => { setAttributes({ show_quantity_input: value }); }}
                            />
                        )}
                        {'wishlist' !== attributes.link_source && 'swatch' !== attributes.link_source && (
                            <ToggleControl
                                label={__('Hide Title', 'alpha-core')}
                                checked={attributes.hide_title}
                                onChange={(value) => { setAttributes({ hide_title: value }); }}
                            />
                        )}
                        {'wishlist' !== attributes.link_source && 'swatch' !== attributes.link_source && (
                            <TextControl
                                label={__('Icon Class (ex: %s)', 'alpha-core').replace('%s', 'w-icon-')}
                                value={attributes.icon_cls}
                                onChange={(value) => { setAttributes({ icon_cls: value }); }}
                            />
                        )}
                        {'cart' === attributes.link_source && (
                            <TextControl
                                label={__('Icon Class for Variable Product (ex: %s)', 'alpha-core').replace('%s', 'w-icon-long-arrow-right')}
                                value={attributes.icon_cls_variable}
                                onChange={(value) => { setAttributes({ icon_cls_variable: value }); }}
                            />
                        )}
                        {'compare' === attributes.link_source && (
                            <TextControl
                                label={__('Icon Class for Added status (ex: %s)', 'alpha-core').replace('%s', 'w-icon-check-solid')}
                                value={attributes.icon_cls_added}
                                onChange={(value) => { setAttributes({ icon_cls_added: value }); }}
                            />
                        )}
                        {(attrs.icon_cls || attributes.icon_cls_variable) && 'wishlist' != attributes.link_source && (
                            <SelectControl
                                label={__('Icon Position', 'alpha-core')}
                                value={attributes.icon_pos}
                                options={[{ label: __('Left', 'alpha-core'), value: 'left' }, { label: __('Right', 'alpha-core'), value: 'right' }]}
                                onChange={(value) => { setAttributes({ icon_pos: value }); }}
                            />
                        )}
                        {(attrs.icon_cls || attributes.icon_cls_variable) && 'wishlist' != attributes.link_source && (
                            <UnitControl
                                label={__('Icon Size', 'alpha-core')}
                                value={attributes.st_icon_fs}
                                onChange={(value) => { setAttributes({ st_icon_fs: value }); }}
                            />
                        )}
                        {(attrs.icon_cls || attributes.icon_cls_variable) && 'wishlist' != attributes.link_source && (
                            <div className={'spacer'} />
                        )}
                        {(attrs.icon_cls || attributes.icon_cls_variable) && 'wishlist' != attributes.link_source && (
                            <UnitControl
                                label={__('Spacing', 'alpha-core')}
                                value={attributes.st_spacing}
                                onChange={(value) => { setAttributes({ st_spacing: value }); }}
                            />
                        )}
                        {(attrs.icon_cls || attributes.icon_cls_variable) && 'wishlist' != attributes.link_source && (
                            <div className={'spacer'} />
                        )}
                        {'swatch' === attributes.link_source && (
                            <SelectControl
                                label={__('Product Attributes', 'alpha-core')}
                                value={attributes.product_attr}
                                options={productAttributes}
                                onChange={(value) => { setAttributes({ product_attr: value }); }}
                            />
                        )}
                        {'swatch' === attributes.link_source && (
                            <RangeControl
                                label={__('Count Limit', 'alpha-core')}
                                value={attributes.attr_limit}
                                min="0"
                                max="10"
                                onChange={(value) => { setAttributes({ attr_limit: value }); }}
                            />
                        )}
                    </PanelBody>
                </InspectorControls>
                <InspectorControls group="styles">
                    <PanelBody title={__('Font Settings', 'alpha-core')} initialOpen={true}>
                        <AlphaTypographyControl
                            label={__('Typography', 'alpha-core')}
                            value={font_settings}
                            options={{}}
                            onChange={(value) => {
                                setAttributes({ font_settings: value });
                            }}
                        />
                    </PanelBody>
                    <AlphaStyleOptionsControl
                        label={__('Style Options', 'alpha-core')}
                        value={style_options}
                        options={{ hoverOptions: true }}
                        onChange={(value) => { setAttributes({ style_options: value }); }}
                    />
                </InspectorControls>
                <Disabled>
                    <style>
                        {internalStyle}
                        {alphaGenerateStyleOptionsCSS(style_options, selectorCls)}
                    </style>
                    {firstRenderForClone && <ServerSideRender
                        block={name}
                        attributes={attrs}
                    />}
                </Disabled>
            </>
        )
    };

    registerBlockType(alpha_admin_vars.theme + '-tb/' + alpha_admin_vars.theme + '-woo-buttons', {
        title: __('Woo Links', 'alpha-core'),
        icon: 'alpha',
        category: alpha_admin_vars.theme + '-tb',
        keywords: ['type builder', 'mini', 'card', 'post', 'woocommerce', 'add to cart', 'quick view', 'compare', 'wishlist', 'yith', 'button', 'product', 'swatch', 'variation'],
        attributes: {
            content_type: {
                type: 'string',
            },
            content_type_value: {
                type: 'string',
            },
            link_source: {
                type: 'string',
            },
            show_quantity_input: {
                type: 'boolean',
            },
            hide_title: {
                type: 'boolean',
            },
            icon_cls: {
                type: 'string',
            },
            icon_cls_variable: {
                type: 'string',
            },
            icon_cls_added: {
                type: 'string',
            },
            icon_pos: {
                type: 'string',
            },
            st_icon_fs: {
                type: 'string',
            },
            st_spacing: {
                type: 'string',
            },
            product_attr: {
                type: 'string',
            },
            attr_limit: {
                type: 'int',
            },
            font_settings: {
                type: 'object',
                default: {},
            },
            style_options: {
                type: 'object',
            },
            el_class: {
                type: 'string',
            },
            className: {
                type: 'string',
            }
        },
        edit: AlphaTBWooButtons,
        save: function () {
            return null;
        }
    });
})(wp.i18n, wp.blocks, wp.blockEditor, wp.components);