<?php
defined( 'ABSPATH' ) || die;

/**
 * Alpha Elementor Shop Show Type Widget Render
 *
 * @author     D-THEMES
 * @package    WP Alpha Core FrameWork
 * @subpackage Core
 * @since      1.2.0
 */
extract( // @codingStandardsIgnoreLine
	shortcode_atts(
		array(
			'grid_icon' => '',
			'list_icon' => '',
		),
		$atts
	)
);

$mode = 'grid';
if ( ! empty( $_REQUEST['showtype'] ) ) {
	$mode = $_REQUEST['showtype'];
}
$base_link = remove_query_arg( 'paged', remove_query_arg( 'showtype' ) );
$grid_url  = add_query_arg( 'showtype', 'grid', $base_link );
$list_url  = add_query_arg( 'showtype', 'list', $base_link );

?>
<div class="toolbox-item">
	<a href="<?php echo esc_url( $base_link ); ?>" class="btn-showtype mode-grid <?php echo esc_attr( $grid_icon ); ?><?php echo 'grid' == $mode ? ' active' : ''; ?>" aria-label="<?php esc_attr_e( 'Grid Layout', 'alpha-core' ); ?>"></a>
	<a href="<?php echo esc_url( $list_url ); ?>" class="btn-showtype mode-list <?php echo esc_attr( $list_icon ); ?><?php echo 'list' == $mode ? ' active' : ''; ?>" aria-label="<?php esc_attr_e( 'List Layout', 'alpha-core' ); ?>"></a>
</div>
<?php
