<?php
defined('ABSPATH') || exit;

if (! class_exists('Togo_Notices')) {

	class Togo_Notices
	{

		protected static $instance = null;

		public static function instance()
		{
			if (null === self::$instance) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		function initialize()
		{
			// Notice Cookie Confirm.
			add_action('wp_ajax_notice_cookie_confirm', array($this, 'notice_cookie_confirm'));
			add_action('wp_ajax_nopriv_notice_cookie_confirm', array($this, 'notice_cookie_confirm'));
		}

		public function notice_cookie_confirm()
		{

			if (
				empty($_POST['_wpnonce']) ||
				! wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['_wpnonce'])), 'notice_cookie_confirm_nonce')
			) {
				wp_send_json_error(esc_html__('Invalid nonce.', 'togo'), 400);
			}

			setcookie(
				'notice_cookie_confirm',
				'yes',
				time() + YEAR_IN_SECONDS,
				COOKIEPATH ? COOKIEPATH : '/',
				COOKIE_DOMAIN,
				is_ssl(),
				true      // HttpOnly
			);

			wp_send_json_success(esc_html__('Cookie confirmed.', 'togo'));
		}

		function get_notice_cookie_messages()
		{
			$notice_messages = Togo\Helper::setting('notice_cookie_messages');
			$button_text     = Togo\Helper::setting('notice_cookie_button_text');

			$messages = '';
			$messages .= '<i class="fal fa-cookie-bite"></i>';
			$messages .= '<p>' . $notice_messages . '</p>';
			$messages .= '<a id="togo-button-cookie-notice-ok" class="togo-button full-filled size-xs wide">' . $button_text . '</a>';

			return $messages;
		}
	}

	Togo_Notices::instance()->initialize();
}
