<?php
/**
 * The template to display the widgets area in the header
 *
 * @package SMARTSEO
 * @since SMARTSEO 1.0
 */

// Header sidebar
$smartseo_header_name    = smartseo_get_theme_option( 'header_widgets' );
$smartseo_header_present = ! smartseo_is_off( $smartseo_header_name ) && is_active_sidebar( $smartseo_header_name );
if ( $smartseo_header_present ) {
	smartseo_storage_set( 'current_sidebar', 'header' );
	$smartseo_header_wide = smartseo_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $smartseo_header_name ) ) {
		dynamic_sidebar( $smartseo_header_name );
	}
	$smartseo_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $smartseo_widgets_output ) ) {
		$smartseo_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $smartseo_widgets_output );
		$smartseo_need_columns   = strpos( $smartseo_widgets_output, 'columns_wrap' ) === false;
		if ( $smartseo_need_columns ) {
			$smartseo_columns = max( 0, (int) smartseo_get_theme_option( 'header_columns' ) );
			if ( 0 == $smartseo_columns ) {
				$smartseo_columns = min( 6, max( 1, smartseo_tags_count( $smartseo_widgets_output, 'aside' ) ) );
			}
			if ( $smartseo_columns > 1 ) {
				$smartseo_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $smartseo_columns ) . ' widget', $smartseo_widgets_output );
			} else {
				$smartseo_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $smartseo_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'smartseo_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $smartseo_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $smartseo_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'smartseo_action_before_sidebar', 'header' );
				smartseo_show_layout( $smartseo_widgets_output );
				do_action( 'smartseo_action_after_sidebar', 'header' );
				if ( $smartseo_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $smartseo_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'smartseo_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
