<?php
/**
 * The template to display default site header
 *
 * @package SMARTSEO
 * @since SMARTSEO 1.0
 */

$smartseo_header_css   = '';
$smartseo_header_image = get_header_image();
$smartseo_header_video = smartseo_get_header_video();
if ( ! empty( $smartseo_header_image ) && smartseo_trx_addons_featured_image_override( is_singular() || smartseo_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$smartseo_header_image = smartseo_get_current_mode_image( $smartseo_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $smartseo_header_image ) || ! empty( $smartseo_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $smartseo_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $smartseo_header_image ) {
		echo ' ' . esc_attr( smartseo_add_inline_css_class( 'background-image: url(' . esc_url( $smartseo_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( smartseo_is_on( smartseo_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight smartseo-full-height';
	}
	$smartseo_header_scheme = smartseo_get_theme_option( 'header_scheme' );
	if ( ! empty( $smartseo_header_scheme ) && ! smartseo_is_inherit( $smartseo_header_scheme  ) ) {
		echo ' scheme_' . esc_attr( $smartseo_header_scheme );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $smartseo_header_video ) ) {
		get_template_part( apply_filters( 'smartseo_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'smartseo_filter_get_template_part', 'templates/header-navi' ) );

	// Mobile header
	if ( smartseo_is_on( smartseo_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'smartseo_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	if ( ! is_single() ) {
		get_template_part( apply_filters( 'smartseo_filter_get_template_part', 'templates/header-title' ) );
	}

	// Header widgets area
	get_template_part( apply_filters( 'smartseo_filter_get_template_part', 'templates/header-widgets' ) );
	?>
</header>
