<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package SMARTSEO
 * @since SMARTSEO 1.0.10
 */

// Footer sidebar
$smartseo_footer_name    = smartseo_get_theme_option( 'footer_widgets' );
$smartseo_footer_present = ! smartseo_is_off( $smartseo_footer_name ) && is_active_sidebar( $smartseo_footer_name );
if ( $smartseo_footer_present ) {
	smartseo_storage_set( 'current_sidebar', 'footer' );
	$smartseo_footer_wide = smartseo_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $smartseo_footer_name ) ) {
		dynamic_sidebar( $smartseo_footer_name );
	}
	$smartseo_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $smartseo_out ) ) {
		$smartseo_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $smartseo_out );
		$smartseo_need_columns = true;   //or check: strpos($smartseo_out, 'columns_wrap')===false;
		if ( $smartseo_need_columns ) {
			$smartseo_columns = max( 0, (int) smartseo_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $smartseo_columns ) {
				$smartseo_columns = min( 4, max( 1, smartseo_tags_count( $smartseo_out, 'aside' ) ) );
			}
			if ( $smartseo_columns > 1 ) {
				$smartseo_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $smartseo_columns ) . ' widget', $smartseo_out );
			} else {
				$smartseo_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $smartseo_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'smartseo_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $smartseo_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $smartseo_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'smartseo_action_before_sidebar', 'footer' );
				smartseo_show_layout( $smartseo_out );
				do_action( 'smartseo_action_after_sidebar', 'footer' );
				if ( $smartseo_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $smartseo_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'smartseo_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
