<?php
/**
 * The template to display default site footer
 *
 * @package SMARTSEO
 * @since SMARTSEO 1.0.10
 */

$smartseo_footer_id = smartseo_get_custom_footer_id();
$smartseo_footer_meta = get_post_meta( $smartseo_footer_id, 'trx_addons_options', true );
if ( ! empty( $smartseo_footer_meta['margin'] ) ) {
	smartseo_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( smartseo_prepare_css_value( $smartseo_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $smartseo_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $smartseo_footer_id ) ) ); ?>
						<?php
						$smartseo_footer_scheme = smartseo_get_theme_option( 'footer_scheme' );
						if ( ! empty( $smartseo_footer_scheme ) && ! smartseo_is_inherit( $smartseo_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $smartseo_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'smartseo_action_show_layout', $smartseo_footer_id );
	?>
</footer><!-- /.footer_wrap -->
