<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package SMARTSEO
 * @since SMARTSEO 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$smartseo_copyright_scheme = smartseo_get_theme_option( 'copyright_scheme' );
if ( ! empty( $smartseo_copyright_scheme ) && ! smartseo_is_inherit( $smartseo_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $smartseo_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$smartseo_copyright = smartseo_get_theme_option( 'copyright' );
			if ( ! empty( $smartseo_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$smartseo_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $smartseo_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$smartseo_copyright = smartseo_prepare_macros( $smartseo_copyright );
				// Display copyright
				echo wp_kses( nl2br( $smartseo_copyright ), 'smartseo_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
