<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package SMARTSEO
 * @since SMARTSEO 1.0
 */

$smartseo_template_args = get_query_var( 'smartseo_template_args' );

if ( is_array( $smartseo_template_args ) ) {
	$smartseo_columns    = empty( $smartseo_template_args['columns'] ) ? 2 : max( 1, $smartseo_template_args['columns'] );
	$smartseo_blog_style = array( $smartseo_template_args['type'], $smartseo_columns );
    $smartseo_columns_class = smartseo_get_column_class( 1, $smartseo_columns, ! empty( $smartseo_template_args['columns_tablet']) ? $smartseo_template_args['columns_tablet'] : '', ! empty($smartseo_template_args['columns_mobile']) ? $smartseo_template_args['columns_mobile'] : '' );
} else {
	$smartseo_template_args = array();
	$smartseo_blog_style = explode( '_', smartseo_get_theme_option( 'blog_style' ) );
	$smartseo_columns    = empty( $smartseo_blog_style[1] ) ? 2 : max( 1, $smartseo_blog_style[1] );
    $smartseo_columns_class = smartseo_get_column_class( 1, $smartseo_columns );
}
$smartseo_expanded   = ! smartseo_sidebar_present() && smartseo_get_theme_option( 'expand_content' ) == 'expand';

$smartseo_post_format = get_post_format();
$smartseo_post_format = empty( $smartseo_post_format ) ? 'standard' : str_replace( 'post-format-', '', $smartseo_post_format );

?><div class="<?php
	if ( ! empty( $smartseo_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( smartseo_is_blog_style_use_masonry( $smartseo_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $smartseo_columns ) : esc_attr( $smartseo_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $smartseo_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $smartseo_columns )
				. ' post_layout_' . esc_attr( $smartseo_blog_style[0] )
				. ' post_layout_' . esc_attr( $smartseo_blog_style[0] ) . '_' . esc_attr( $smartseo_columns )
	);
	smartseo_add_blog_animation( $smartseo_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$smartseo_hover      = ! empty( $smartseo_template_args['hover'] ) && ! smartseo_is_inherit( $smartseo_template_args['hover'] )
							? $smartseo_template_args['hover']
							: smartseo_get_theme_option( 'image_hover' );

	$smartseo_components = ! empty( $smartseo_template_args['meta_parts'] )
							? ( is_array( $smartseo_template_args['meta_parts'] )
								? $smartseo_template_args['meta_parts']
								: explode( ',', $smartseo_template_args['meta_parts'] )
								)
							: smartseo_array_get_keys_by_value( smartseo_get_theme_option( 'meta_parts' ) );

	smartseo_show_post_featured( apply_filters( 'smartseo_filter_args_featured',
		array(
			'thumb_size' => ! empty( $smartseo_template_args['thumb_size'] )
				? $smartseo_template_args['thumb_size']
				: smartseo_get_thumb_size(
					'classic' == $smartseo_blog_style[0]
						? ( strpos( smartseo_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $smartseo_columns > 2 ? 'big' : 'huge' )
								: ( $smartseo_columns > 2
									? ( $smartseo_expanded ? 'square' : 'square' )
									: ($smartseo_columns > 1 ? 'square' : ( $smartseo_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( smartseo_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $smartseo_columns > 2 ? 'masonry-big' : 'full' )
								: ($smartseo_columns === 1 ? ( $smartseo_expanded ? 'huge' : 'big' ) : ( $smartseo_columns <= 2 && $smartseo_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $smartseo_hover,
			'meta_parts' => $smartseo_components,
			'no_links'   => ! empty( $smartseo_template_args['no_links'] ),
        ),
        'content-classic',
        $smartseo_template_args
    ) );

	// Title and post meta
	$smartseo_show_title = get_the_title() != '';
	$smartseo_show_meta  = count( $smartseo_components ) > 0 && ! in_array( $smartseo_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $smartseo_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'smartseo_filter_show_blog_meta', $smartseo_show_meta, $smartseo_components, 'classic' ) ) {
				if ( count( $smartseo_components ) > 0 ) {
					do_action( 'smartseo_action_before_post_meta' );
					smartseo_show_post_meta(
						apply_filters(
							'smartseo_filter_post_meta_args', array(
							'components' => join( ',', $smartseo_components ),
							'seo'        => false,
							'echo'       => true,
						), $smartseo_blog_style[0], $smartseo_columns
						)
					);
					do_action( 'smartseo_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'smartseo_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'smartseo_action_before_post_title' );
				if ( empty( $smartseo_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'smartseo_action_after_post_title' );
			}

			if( !in_array( $smartseo_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'smartseo_filter_show_blog_readmore', ! $smartseo_show_title || ! empty( $smartseo_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $smartseo_template_args['no_links'] ) ) {
						do_action( 'smartseo_action_before_post_readmore' );
						smartseo_show_post_more_link( $smartseo_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'smartseo_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $smartseo_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('smartseo_filter_show_blog_excerpt', empty($smartseo_template_args['hide_excerpt']) && smartseo_get_theme_option('excerpt_length') > 0, 'classic')) {
			smartseo_show_post_content($smartseo_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $smartseo_template_args['more_button'] )) {
			if ( empty( $smartseo_template_args['no_links'] ) ) {
				do_action( 'smartseo_action_before_post_readmore' );
				smartseo_show_post_more_link( $smartseo_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'smartseo_action_after_post_readmore' );
			}
		}
		$smartseo_content = ob_get_contents();
		ob_end_clean();
		smartseo_show_layout($smartseo_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
