<?php
/**
 * The template to display single post
 *
 * @package SMARTSEO
 * @since SMARTSEO 1.0
 */

// Full post loading
$full_post_loading          = smartseo_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = smartseo_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = smartseo_get_theme_option( 'posts_navigation_scroll_which_block', 'article' );

// Position of the related posts
$smartseo_related_position   = smartseo_get_theme_option( 'related_position', 'below_content' );

// Type of the prev/next post navigation
$smartseo_posts_navigation   = smartseo_get_theme_option( 'posts_navigation' );
$smartseo_prev_post          = false;
$smartseo_prev_post_same_cat = (int)smartseo_get_theme_option( 'posts_navigation_scroll_same_cat', 1 );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( smartseo_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	smartseo_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'smartseo_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $smartseo_posts_navigation ) {
		$smartseo_prev_post = get_previous_post( $smartseo_prev_post_same_cat );  // Get post from same category
		if ( ! $smartseo_prev_post && $smartseo_prev_post_same_cat ) {
			$smartseo_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $smartseo_prev_post ) {
			$smartseo_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $smartseo_prev_post ) ) {
		smartseo_sc_layouts_showed( 'featured', false );
		smartseo_sc_layouts_showed( 'title', false );
		smartseo_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $smartseo_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'smartseo_filter_get_template_part', 'templates/content', 'single-' . smartseo_get_theme_option( 'single_style' ) ), 'single-' . smartseo_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $smartseo_related_position, 'inside' ) === 0 ) {
		$smartseo_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'smartseo_action_related_posts' );
		$smartseo_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $smartseo_related_content ) ) {
			$smartseo_related_position_inside = max( 0, min( 9, smartseo_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $smartseo_related_position_inside ) {
				$smartseo_related_position_inside = mt_rand( 1, 9 );
			}

			$smartseo_p_number         = 0;
			$smartseo_related_inserted = false;
			$smartseo_in_block         = false;
			$smartseo_content_start    = strpos( $smartseo_content, '<div class="post_content' );
			$smartseo_content_end      = strrpos( $smartseo_content, '</div>' );

			for ( $i = max( 0, $smartseo_content_start ); $i < min( strlen( $smartseo_content ) - 3, $smartseo_content_end ); $i++ ) {
				if ( $smartseo_content[ $i ] != '<' ) {
					continue;
				}
				if ( $smartseo_in_block ) {
					if ( strtolower( substr( $smartseo_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$smartseo_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $smartseo_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $smartseo_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$smartseo_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $smartseo_content[ $i + 1 ] && in_array( $smartseo_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$smartseo_p_number++;
					if ( $smartseo_related_position_inside == $smartseo_p_number ) {
						$smartseo_related_inserted = true;
						$smartseo_content = ( $i > 0 ? substr( $smartseo_content, 0, $i ) : '' )
											. $smartseo_related_content
											. substr( $smartseo_content, $i );
					}
				}
			}
			if ( ! $smartseo_related_inserted ) {
				if ( $smartseo_content_end > 0 ) {
					$smartseo_content = substr( $smartseo_content, 0, $smartseo_content_end ) . $smartseo_related_content . substr( $smartseo_content, $smartseo_content_end );
				} else {
					$smartseo_content .= $smartseo_related_content;
				}
			}
		}

		smartseo_show_layout( $smartseo_content );
	}

	// Comments
	do_action( 'smartseo_action_before_comments' );
	comments_template();
	do_action( 'smartseo_action_after_comments' );

	// Related posts
	if ( 'below_content' == $smartseo_related_position
		&& ( 'scroll' != $smartseo_posts_navigation || (int)smartseo_get_theme_option( 'posts_navigation_scroll_hide_related', 0 ) == 0 )
		&& ( ! $full_post_loading || (int)smartseo_get_theme_option( 'open_full_post_hide_related', 1 ) == 0 )
	) {
		do_action( 'smartseo_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $smartseo_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $smartseo_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $smartseo_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $smartseo_prev_post ) ); ?>"
			data-cur-post-link="<?php echo esc_attr( get_permalink() ); ?>"
			data-cur-post-title="<?php the_title_attribute(); ?>"
			<?php do_action( 'smartseo_action_nav_links_single_scroll_data', $smartseo_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
