<?php
class Bookings
{

	// class instance
	static $instance;

	// customer WP_List_Table object
	public $customers_obj;

	// class constructor
	public function __construct()
	{
		add_filter('set-screen-option', [__CLASS__, 'set_screen'], 10, 3);
		add_action('admin_menu', [$this, 'plugin_menu']);
		add_action('admin_menu', [$this, 'bookingDetails']);
		add_action('wp_ajax_eventer_export_bookings', [ $this, 'eventer_export_bookings' ] );

        add_action("wp_ajax_custom_bulk_delete_bookings", [$this, "custom_bulk_delete_bookings"]);
	}

	public function eventer_export_bookings() {
        global $wpdb;
        $tickets_table = $wpdb->prefix . "eventer_registration_tickets";
        $registrations_table = $wpdb->prefix . "eventer_registrations";
        $specific_event = isset($_REQUEST['eventer']) ? $_REQUEST['eventer'] : '';
        $start_date = isset($_REQUEST['start_date']) ? $_REQUEST['start_date'] : '';
        $end_date = isset($_REQUEST['end_date']) ? $_REQUEST['end_date'] : '';
        $event_date = isset($_REQUEST['event_date']) ? $_REQUEST['event_date'] : '';
        $order_status = isset($_REQUEST['order_status']) ? $_REQUEST['order_status'] : '';
        $bookings_list = isset($_REQUEST['multipleslect']) ? array_map('intval', $_REQUEST['multipleslect']) : [];

        $where = [];
        if ($specific_event != '') {
            $where[] = $wpdb->prepare("t.event_id = %d", $specific_event);
        }
        if (!empty($start_date)) {
            $where[] = $wpdb->prepare("r.reg_date >= %s", date('Y-m-d 00:00:00', strtotime($start_date)));
        }
        if (!empty($end_date)) {
            $where[] = $wpdb->prepare("r.reg_date <= %s", date('Y-m-d 23:59:59', strtotime($end_date)));
        }

        if (!empty($event_date)) {
            $where[] = $wpdb->prepare("DATE(t.ticket_date) = %s", date('Y-m-d', strtotime($event_date)));
        }
        if ($order_status != '') {
            $where[] = $wpdb->prepare("r.reg_status = %s", $order_status);
        }

        if (!empty($bookings_list)) {
            $where[] = "t.reg_id IN (" . implode(',', $bookings_list) . ")";
        }

        $where_sql = '';
        if (!empty($where)) {
            $where_sql = 'WHERE ' . implode(' AND ', $where);
        }

        $query = "
            SELECT t.*, r.reg_date
            FROM $tickets_table AS t
            INNER JOIN $registrations_table AS r ON t.reg_id = r.id
            $where_sql
        ";

		$wpdb->show_errors();
		$export_query = $wpdb->get_results($query, ARRAY_A);

		if (!$export_query) {
			$Error = $wpdb->print_error();
			die("The following error was found: $Error");
		} else {
			$array_data = [];
			foreach ($export_query as $data) {
				$result = getRegistration($data['reg_id'], 10, 1, 'id');
				if (!$result) {
					continue;
				}

				$final_data = get_object_vars($result);
				$final_data['user_name'] = getTicketMeta($data['id'], 'name');
				$final_data['user_email'] = getTicketMeta($data['id'], 'email');
				$final_data['qr_code'] = $data['id'];
				$registrants = @unserialize(getTicketMeta($data['id'], 'reg_details'));

				if (is_array($registrants)) {
					foreach ($registrants as $field_key => $value) {
						$position1 = stripos($field_key, 'Registrant name');
						$position2 = stripos($field_key, 'Registrant email');
						if ($position1 !== false || $position2 !== false) {
							unset($registrants[$field_key]);
						}
					}
				}

				$final_data['registrants'] = $registrants;
                // Remove any undefined or invalid fields from the registrant data
                if (!empty($final_data['registrants']) && is_array($final_data['registrants'])) {
                    foreach ($final_data['registrants'] as $key => $value) {
                        if ($key === 'undefined' || stripos($value, 'C:\\fakepath\\') !== false) {
                            unset($final_data['registrants'][$key]);
                        }
                    }
                }
				$final_data['ticket_name'] = isset($data['ticket_name']) ? $data['ticket_name'] : '';
				$final_data['ticket_status'] = isset($data['ticket_status']) ? $data['ticket_status'] : '';
				$array_data[] = $final_data;
			}
            
			// Get saved settings for CSV fields
            $selected_fields = eventer_get_settings('eventer_woo_csv_export_fields', []);

            // Check if user-selected fields exist in the URL (via query parameters)
            if (!empty($_REQUEST['export_fields']) && is_array($_REQUEST['export_fields'])) {
                $selected_fields = array_map('sanitize_text_field', $_REQUEST['export_fields']);
            }

            // Define all available fields (excluding "Name" since it's always included)
            $available_fields = [
                'booking_id'    => 'Booking ID',
                'status'        => 'Status',
                'user_id'       => 'User ID',
                'order_id'      => 'Order ID',
                'booking_date'  => 'Booking Date',
                'payment_mode'  => 'Payment Mode',
                'amount'        => 'Amount',
                'event_title'   => 'Event Title',
                'event_date'    => 'Event Date',
                'qr_id'         => 'QR ID',
                'checked_in'    => 'Checked-in',
                'email'         => 'Email',
                'registrant_fields' => 'Registrant Fields',
                'billing_phone' => 'Phone',
                'ticket_name'   => 'Ticket Name',
                'services'      => 'Services',
            ];

            // If no settings exist, select all fields by default
            if (empty($selected_fields)) {
                $selected_fields = array_keys($available_fields);
            }

           // Check if export fields are provided via GET (override global settings)
            if (!empty($_GET['export_fields']) && is_array($_GET['export_fields'])) {
                $selected_fields = array_map('sanitize_text_field', $_GET['export_fields']);
            } elseif (empty($selected_fields)) {
                $selected_fields = array_keys($available_fields); // Default to all fields if no setting exists
            }

            $csv_fields = [];

            foreach ($selected_fields as $key) {
                if (isset($available_fields[$key])) {
                    $csv_fields[] = $available_fields[$key];
                }
            }

            // Ensure "Name" appears in its correct position after Email
            if (!in_array('name', $selected_fields)) {
                $email_position = array_search('Email', $csv_fields);
                if ($email_position !== false) {
                    array_splice($csv_fields, $email_position + 1, 0, ['Name']);
                } else {
                    $csv_fields[] = 'Name'; // Add at the end if Email isn't selected
                }
            }

            // Ensure Registrant Fields are inserted in the correct position
            if (in_array('registrant_fields', $selected_fields)) {
                $dynamic_fields = eventer_get_settings('individual_registrant_fields');
                $fieldName = 'name';
                $pattern = '/\b' . preg_quote($fieldName, '/') . '="(.*?)"/';
                $custom_field_keys = [];

                if (preg_match_all($pattern, $dynamic_fields, $matches)) {
                    $custom_field_keys = $matches[1];
                }

                // Ensure all custom fields are added
                foreach ($array_data as $data) {
                    if (!empty($data['registrants']) && is_array($data['registrants'])) {
                        foreach ($data['registrants'] as $key => $value) {
                            if (!in_array($key, $custom_field_keys)) {
                                $custom_field_keys[] = $key;
                            }
                        }
                    }
                }

                // Insert Registrant Fields **after Email or Name**
                $insert_position = array_search('Email', $csv_fields) ?: array_search('Name', $csv_fields);
                array_splice($csv_fields, $insert_position + 1, 0, $custom_field_keys);
            }

            // Ensure no duplicate 'name' or 'email' columns
            $csv_fields = array_unique($csv_fields);
            
            // Remove 'name' and 'email' from $csv_fields if they exist as extra columns
            $csv_fields = array_filter($csv_fields, function ($column) {
                return !in_array($column, ['name', 'email']);
            });

            // Remove 'Registrant Fields' placeholder if it's in the headers
            $csv_fields = array_diff($csv_fields, ['Registrant Fields']);
            
            // Ensure "Name" appears before "Email"
            if (in_array('email', $selected_fields)) {
                $email_position = array_search('Email', $csv_fields);
                if ($email_position !== false) {
                    array_splice($csv_fields, $email_position, 0, ['Name']);
                }
            } else {
                $csv_fields[] = 'Name'; // If "Email" isn't selected, add "Name" at the end
            }

            // Allow users to modify CSV headers from their child theme
            $csv_fields = apply_filters('eventer_modify_csv_headers', $csv_fields);
            
            $csv_fields = array_unique($csv_fields);

			$output_filename = 'eventer_booking_csv_' . date_i18n("Y-m-d_H-i-s") . ".csv";
			$output_handle = @fopen('php://output', 'w');

            // Add UTF-8 BOM so Excel handles non-English characters (like Tamil) properly
            fwrite($output_handle, "\xEF\xBB\xBF");

			header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            header('Content-Description: File Transfer');
            header('Content-type: text/csv; charset=UTF-8');
            header('Content-Disposition: attachment; filename=' . $output_filename);
            header('Expires: 0');
            header('Pragma: public');

			fputcsv($output_handle, $csv_fields);

			foreach ($array_data as $Result) {
				$woo_order = $Result['order_id'];
				$order = wc_get_order($woo_order);

				if (!$order) {
					continue;
				}

				$already_printed = false;
				foreach ($order->get_items() as $item_key => $item_values) {
					if ($already_printed) {
						continue;
					}

					$item_data = $item_values->get_data();
					$item_id = $item_values->get_id();
					$product_name = $item_data['name'];
					$eventer_id = wc_get_order_item_meta($item_id, '_wceventer_id', true);
					$eventer_date = wc_get_order_item_meta($item_id, '_wceventer_date', true);
					$data_set = array_fill_keys($csv_fields, ''); // Ensure proper alignment

                    // Assign data based on ordered headers
                    foreach ($csv_fields as $column_title) {
                        switch ($column_title) {
                            case 'Booking ID':
                                $data_set[$column_title] = $Result['id'];
                                break;
                            case 'Status':
                                $data_set[$column_title] = $Result['reg_status'];
                                break;
                            case 'User ID':
                                $data_set[$column_title] = $Result['user_id'];
                                break;
                            case 'Order ID':
                                $data_set[$column_title] = $woo_order;
                                break;
                            case 'Booking Date':
                                $data_set[$column_title] = date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($Result['reg_date']));
                                break;
                            case 'Payment Mode':
                                $data_set[$column_title] = !empty($Result['paymentmode']) ? $Result['paymentmode'] : 'N/A';
                                break;
                            case 'Amount':
                                $data_set[$column_title] = $Result['reg_amount'];
                                break;
                            case 'Event Title':
                                $data_set[$column_title] = get_the_title($eventer_id);
                                break;
                            case 'Event Date':
                                $data_set[$column_title] = date_i18n(get_option('date_format'), strtotime($eventer_date));
                                break;
                            case 'QR ID':
                                $data_set[$column_title] = $Result['qr_code'];
                                break;
                            case 'Checked-in':
                                $data_set[$column_title] = ($Result['ticket_status'] == '10') ? 'Yes' : 'No';
                                break;
                            case 'Name': // Ensure "Name" is assigned before "Email"
                                $data_set[$column_title] = !empty($Result['user_name']) ? $Result['user_name'] : $order->get_billing_first_name() . ' ' . $order->get_billing_last_name();
                                break;
                            case 'Email':
                                $data_set[$column_title] = !empty($Result['user_email']) ? $Result['user_email'] : $order->get_billing_email();
                                break;
                        }
                    }

                    // Handle Registrant Fields correctly
                    if (isset($Result['registrants']) && is_array($Result['registrants'])) {
                        foreach ($custom_field_keys as $field_name) {
                            if (array_key_exists($field_name, $data_set)) {
                                $data_set[$field_name] = isset($Result['registrants'][$field_name]) ? $Result['registrants'][$field_name] : 'N/A';
                            }
                        }
                    }

                    // Remove unwanted duplicate columns 'name' and 'email' if mistakenly added
                    unset($data_set['name'], $data_set['email']);
                    unset($data_set['Name.1']);
                    
                    // Process remaining selected fields
                    foreach ($csv_fields as $column_title) {
                        switch ($column_title) {
                            case 'Phone':
                                $data_set[$column_title] = !empty($order->get_billing_phone()) ? $order->get_billing_phone() : 'N/A';
                                break;
                            case 'Ticket Name':
                                $data_set[$column_title] = !empty($Result['ticket_name']) ? $Result['ticket_name'] : $product_name;
                                break;
                            case 'Services':
                                $services_list = [];
                                foreach ($order->get_items() as $item_id => $item) {
                                    $eventer_product_type = wc_get_order_item_meta($item_id, '_eventer_product', true);
                                    if ($eventer_product_type === 'service') {
                                        $service_name = $item->get_name();
                                        $service_meta = wc_get_order_item_meta($item_id, 'Services', true);
                                        if (!empty($service_meta)) {
                                            $service_meta = trim($service_meta, " ,");
                                            $service_entries = array_filter(array_map('trim', explode(',', $service_meta)));
                                            foreach ($service_entries as $service_entry) {
                                                $services_list[] = "{$service_name} - {$service_entry}";
                                            }
                                        } else {
                                            $services_list[] = "{$service_name} - N/A";
                                        }
                                    }
                                }
                                $data_set[$column_title] = !empty($services_list) ? implode(', ', $services_list) : 'None';
                                break;
                        }
                    }
                    // Remove any undefined or fake path values from CSV
                    $data_set = array_filter($data_set, function($value, $key) {
                        return $key !== 'undefined' && stripos($value, 'C:\\fakepath\\') === false;
                    }, ARRAY_FILTER_USE_BOTH);
                    $data_set = apply_filters('eventer_modify_csv_row', $data_set, $order);
                    
					fputcsv($output_handle, $data_set);
					$already_printed = true;
				}
			}

			fclose($output_handle);
			die();
		}
	}

  public static function set_screen($status, $option, $value)
  {
    return $value;
  }

  public function plugin_menu() {
    global $submenu;

    // Add submenu under "Eventer" (CPT menu)
    $hook = add_submenu_page(
        'edit.php?post_type=eventer', // Parent menu (Eventer)
        __('Woo Bookings', 'eventer'), // Page title
        __('Woo Bookings', 'eventer'), // Menu title
        'manage_options', // Capability
        'eventer_bookings', // Menu slug
        [$this, 'plugin_settings_page'] // Callback function
    );

    add_action("load-$hook", [$this, 'screen_option']);

    // Force highlight the correct parent menu
    add_filter('parent_file', function($parent_file) {
        global $pagenow;

        if ($pagenow === 'admin.php' && isset($_GET['page']) && $_GET['page'] === 'eventer_bookings') {
            return 'edit.php?post_type=eventer'; // Keeps "Eventer" menu open
        }

        return $parent_file;
    });

    // Also, highlight submenu properly
    add_filter('submenu_file', function($submenu_file) {
        global $pagenow;

        if ($pagenow === 'admin.php' && isset($_GET['page']) && $_GET['page'] === 'eventer_bookings') {
            return 'eventer_bookings'; // Highlights Woo Bookings menu item
        }

        return $submenu_file;
    });
}


  public function bookingDetails()
  {

    $hook = add_menu_page(
      'Booking Details',
      'Booking Details',
      'manage_options',
      'booking_details',
      [$this, 'bookingDetailsPage']
    );

    add_action("load-$hook", [$this, 'screen_option']);
  }

  /**
   * Screen options
   */
  public function screen_option()
  {

    $option = 'per_page';
    $args = [
      'label' => 'Bookings',
      'default' => 20,
      'option' => 'customers_per_page'
    ];

    add_screen_option($option, $args);

    $this->customers_obj = new RegistrationTable();
  }

  /**
   * Plugin settings page
   */
	public function plugin_settings_page()
	  {
		$reg_details = $this->getBookings();

		?>
		<div class="wrap">
		  <h2>Eventer Bookings</h2>
		  <?php if (!empty($reg_details) || isset($_REQUEST['start_date']) || isset($_REQUEST['end_date'])) : ?>
			<form class="test-form" action="<?php echo esc_url(admin_url('admin-ajax.php')); ?>" method="post">
			<input type="hidden" name="action" value="eventer_export_bookings">
			<input type="hidden" name="date" value="<?php echo (isset($_REQUEST['booking'])) ? $_REQUEST['booking'] : ''; ?>">
			<input type="hidden" name="eventer" value="<?php echo (isset($_REQUEST['eventer'])) ? $_REQUEST['eventer'] : ''; ?>">
            <input type="hidden" name="event_date" value="<?php echo isset($_REQUEST['event_date']) ? esc_attr($_REQUEST['event_date']) : ''; ?>">
			<input type="hidden" name="eventer_all" value="<?php echo (isset($_REQUEST['eventer_id'])) ? $_REQUEST['eventer_id'] : ''; ?>">
            <input type="hidden" name="order_status" value="<?php echo isset($_REQUEST['order_status']) ? esc_attr($_REQUEST['order_status']) : ''; ?>">
            <?php
            // Get saved settings for CSV fields
            $saved_settings = eventer_get_settings('eventer_woo_csv_export_fields', []);

            // Check if user-selected fields exist in the request
            $selected_fields = isset($_REQUEST['export_fields']) ? $_REQUEST['export_fields'] : $saved_settings;

            // Define all available fields
            $available_fields = [
                'booking_id'    => 'Booking ID',
                'status'        => 'Status',
                'user_id'       => 'User ID',
                'order_id'      => 'Order ID',
                'booking_date'  => 'Booking Date',
                'payment_mode'  => 'Payment Mode',
                'amount'        => 'Amount',
                'event_title'   => 'Event Title',
                'event_date'    => 'Event Date',
                'qr_id'         => 'QR ID',
                'checked_in'    => 'Checked-in',
                'email'         => 'Email',
                'registrant_fields' => 'Registrant Fields',
                'billing_phone' => 'Phone',
                'ticket_name'   => 'Ticket Name',
                'services'      => 'Services',
            ];

            // If no settings exist, default to all fields
            if (empty($selected_fields)) {
                $selected_fields = array_keys($available_fields);
            }
            ?>

            <!-- CSV Export Toggle Button -->
            <button type="button" id="toggle-woo-csv-export-fields" class="button"><?php esc_html_e('Select Export Fields', 'eventer'); ?></button>

            <!-- Hidden Field Selection -->
            <div id="woo-csv-export-fields-container" style="display: none; margin: 10px 0; border: 1px solid #ccc; padding: 10px; background: #f9f9f9;">
                <h3><?php esc_html_e('Select Fields for Export', 'eventer'); ?></h3>
                <p><?php esc_html_e('Check the fields you want to include in the CSV export. Default selection of the fields can be managed from the Settings page.', 'eventer'); ?></p>
                <div class="eventer-csv-fields-selection">
                    <?php foreach ($available_fields as $key => $label) : ?>
                        <label>
                            <input type="checkbox" class="eventer-export-field" name="export_fields[]" value="<?php echo esc_attr($key); ?>"
                                <?php echo (is_array($selected_fields) && in_array($key, $selected_fields)) ? 'checked' : ''; ?>>
                            <?php echo esc_html($label); ?>
                        </label>
                        <br>
                    <?php endforeach; ?>
                </div>
            </div>

			<input type="submit" value="<?php esc_html_e('Download CSV', 'eventer'); ?>" class="button button-primary eventer-download-bulk-downloading">
			</form>
		  <?php endif; ?>

		  <div id="poststuff">
			<div id="post-body" class="metabox-holder">
			  <div id="post-body-content">
				<div class="meta-box-sortables ui-sortable">
				  <form class="form-eventer_bookins" action="<?php echo esc_url(admin_url('edit.php?post_type=eventer&page=eventer_bookings')); ?>" method="post">
					<?php
						$this->customers_obj->prepare_items();
						$this->customers_obj->display(); ?>
				  </form>
				</div>
			  </div>
			</div>
			<br class="clear">
		  </div>
		</div>
        <style>
            /* Hide Default Bulk Actions */
            .tablenav.top .bulkactions,
            .tablenav.bottom .bulkactions {
                display: none !important;
            }
        </style>
	<?php
    }

    public function custom_bulk_delete_bookings() {
        // Security Check: Only allow admins
        if (!current_user_can('manage_options')) {
            wp_send_json_error(['message' => 'Unauthorized']);
            exit;
        }

        // Check if bulk delete data is set
        if (!isset($_POST["delete_bookings"]) || !is_array($_POST["delete_bookings"])) {
            wp_send_json_error(["message" => "No bookings selected for deletion."]);
        }

        global $wpdb;
        $delete_ids = array_map('absint', $_POST["delete_bookings"]); // Sanitize input

        if (!empty($delete_ids)) {
            foreach ($delete_ids as $id) {
                $this->delete_booking($id);
            }
        }

        wp_send_json_success(["message" => "Selected bookings deleted successfully."]);
    }

    /**
     * Deletes a single booking and associated data.
     */
    public function delete_booking($id) {
        global $wpdb;

        // Get WooCommerce Order ID linked to the booking
        $order_id = $wpdb->get_var($wpdb->prepare(
            "SELECT order_id FROM {$wpdb->prefix}eventer_registrations WHERE id = %d",
            $id
        ));

        // Delete WooCommerce Order if it exists
        if (!empty($order_id)) {
            $this->delete_woocommerce_order($order_id);
        }

        // Delete related ticket data
        $tickets_table_name = $wpdb->prefix . "eventer_registration_tickets";
        $ticket_ids = $wpdb->get_col($wpdb->prepare("SELECT id FROM $tickets_table_name WHERE reg_id = %d", $id));

        if (!empty($ticket_ids)) {
            $ticket_meta_table = $wpdb->prefix . "eventer_ticket_meta";
            foreach ($ticket_ids as $ticket) {
                $wpdb->delete($ticket_meta_table, ["ticket_id" => $ticket]);
            }
            $wpdb->delete($tickets_table_name, ["reg_id" => $id]);
        }

        // Delete registration meta
        $meta_table_name = $wpdb->prefix . "eventer_registration_meta";
        $wpdb->delete($meta_table_name, ["reg_id" => $id]);

        // Delete main Eventer registration record
        $registrations_table = $wpdb->prefix . "eventer_registrations";
        $wpdb->delete($registrations_table, ["id" => $id]);
    }

    public function delete_woocommerce_order($order_id) {
        if (!empty($order_id)) {
            // Check if HPOS (High-Performance Order Storage) is enabled
            if (class_exists('Automattic\WooCommerce\Utilities\OrderUtil') &&
                method_exists('Automattic\WooCommerce\Utilities\OrderUtil', 'custom_orders_table_usage_is_enabled') &&
                \Automattic\WooCommerce\Utilities\OrderUtil::custom_orders_table_usage_is_enabled()
            ) {
                // HPOS is enabled, use WooCommerce order deletion
                $order = wc_get_order($order_id);
                if ($order) {
                    $order->delete(true); // Force delete HPOS order
                    return;
                }
            }

            // Fallback: Delete WooCommerce order as a WordPress post (Legacy WooCommerce method)
            if (get_post_type($order_id) === 'shop_order') {
                wp_delete_post($order_id, true); // True = Permanent delete
            }
        }
    }

    public function getBookings($per_page = 20, $page_number = 1) {
        global $wpdb;
        $tickets_table = $wpdb->prefix . "eventer_registration_tickets";
        $registrations_table = $wpdb->prefix . "eventer_registrations";
        $specific_event = isset($_REQUEST['eventer']) ? $_REQUEST['eventer'] : '';
        $bookings = isset($_REQUEST['multipleslect']) ? $_REQUEST['multipleslect'] : [];
        $start_date = isset($_REQUEST['start_date']) ? $_REQUEST['start_date'] : '';
        $end_date = isset($_REQUEST['end_date']) ? $_REQUEST['end_date'] : '';
        $event_date = isset($_REQUEST['event_date']) ? $_REQUEST['event_date'] : '';
        $order_status = isset($_REQUEST['order_status']) ? $_REQUEST['order_status'] : '';
        $bookings_list = [];

        if ($bookings) {
            foreach ($bookings as $id) {
                if (!intval($id)) {
                    continue;
                }
                $bookings_list[] = $id;
            }
        }

        $where = [];

        // Filter by specific event (skip if "All Events" is selected)
        if (!empty($specific_event)) {
            $where[] = $wpdb->prepare("t.event_id = %d", $specific_event);
        }

        // Filter by booking date range
        if (!empty($start_date)) {
            $where[] = $wpdb->prepare("r.reg_date >= %s", date('Y-m-d 00:00:00', strtotime($start_date)));
        }
        if (!empty($end_date)) {
            $where[] = $wpdb->prepare("r.reg_date <= %s", date('Y-m-d 23:59:59', strtotime($end_date)));
        }

        // Filter by event date – Use DATE() function to extract only the date part
        if (!empty($event_date)) {
            $where[] = $wpdb->prepare("DATE(t.ticket_date) = %s", date('Y-m-d', strtotime($event_date)));
        }

        // Filter by specific order status
        if (!empty($order_status)) {
            $where[] = $wpdb->prepare("r.reg_status = %s", $order_status);
        }

        // Filter by selected bookings
        if (!empty($bookings_list)) {
            $where[] = "t.reg_id IN (" . implode(',', array_map('intval', $bookings_list)) . ")";
        }

        $where_sql = !empty($where) ? 'WHERE ' . implode(' AND ', $where) : '';

        $offset = ($page_number - 1) * $per_page;

        $query = "
            SELECT t.*, r.reg_date
            FROM $tickets_table AS t
            INNER JOIN $registrations_table AS r ON t.reg_id = r.id
            $where_sql
            ORDER BY r.reg_date DESC
            LIMIT $offset, $per_page
        ";

        $wpdb->show_errors();
        $results = $wpdb->get_results($query, ARRAY_A);

        if (!$results) {
            return [];
        } else {
            $array_data = [];
            foreach ($results as $key => $data) {
                $result = getRegistration($data['reg_id'], 10, 1, 'id');
                if (!$result) {
                    continue;
                }
                $array_data[] = get_object_vars($result);
            }
        }

        return $array_data;
    }

  /**
   * Plugin settings page
   */
  public function bookingDetailsPage()
  {
    $bookingId = isset($_REQUEST['booking_id']) ? $_REQUEST['booking_id'] : '';
    $bookingDetails = getRegistration($bookingId);
    $bookingTickets = getRegistrationTickets($bookingId);
    eventer_append_template_with_arguments('eventers/admin/booking', "details", ['booking' => (array) $bookingDetails, 'tickets' => $bookingTickets]);
  }

  /** Singleton instance */
  public static function get_instance()
  {
    if (!isset(self::$instance)) {
      self::$instance = new self();
    }

    return self::$instance;
  }
}
add_action('plugins_loaded', function () {
  Bookings::get_instance();
});
