<?php
// Restrictive wrapper around do_shortcode that allows only Eventer tags.
if ( ! function_exists( 'eventer_safe_do_shortcode' ) ) {
    function eventer_safe_do_shortcode( $content, $allowed_prefixes = array( 'eventer_' ), $extra_allowed = array() ) {
        if ( ! is_string( $content ) || $content === '' ) {
            return '';
        }

        // Sanitize HTML first (prevents script/style injection if content is user-controlled).
        $content = wp_kses_post( $content );

        global $shortcode_tags;

        // Backup the global registry.
        $original_tags = $shortcode_tags;

        // Build a whitelist from currently registered shortcodes.
        $whitelist = array();
        foreach ( $shortcode_tags as $tag => $callback ) {
            // Allow explicit extras if ever needed.
            if ( in_array( $tag, $extra_allowed, true ) ) {
                $whitelist[ $tag ] = $callback;
                continue;
            }
            // Allow by prefix, e.g., all 'eventer_*' tags.
            foreach ( $allowed_prefixes as $prefix ) {
                if ( strpos( $tag, $prefix ) === 0 ) {
                    $whitelist[ $tag ] = $callback;
                    break;
                }
            }
        }

        // Temporarily restrict available shortcodes to our whitelist.
        $shortcode_tags = $whitelist;

        // Expand only allowed shortcodes.
        $output = do_shortcode( $content );

        // Restore the global registry.
        $shortcode_tags = $original_tags;

        return $output;
    }
}