<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Eventer Webhooks Helper
 */
class Eventer_Webhooks {

    /**
     * Trigger webhook request
     *
     * @param string $hook_name
     * @param array $payload
     */
    public static function trigger( $hook_name, $payload ) {
        $webhook_url = apply_filters( 'eventer_webhook_url', '' ); // Let developers hook into it

        if ( empty( $webhook_url ) ) {
            return;
        }

        wp_remote_post( $webhook_url, [
            'method'    => 'POST',
            'timeout'   => 10,
            'headers'   => [
                'Content-Type' => 'application/json',
            ],
            'body'      => wp_json_encode([
                'hook'    => $hook_name,
                'payload' => $payload,
            ]),
        ] );
    }
}
