<?php
// Schedule the cron job for ticket maintenance
add_action('wp', 'schedule_ticket_maintenance_cron');
function schedule_ticket_maintenance_cron() {
    if (!wp_next_scheduled('eventer_ticket_maintenance_cron')) {
        wp_schedule_event(time(), 'daily', 'eventer_ticket_maintenance_cron');
    }
}

// Function to delete old PDF tickets
add_action('eventer_ticket_maintenance_cron', 'delete_old_ticket_pdfs');
function delete_old_ticket_pdfs() {
    // Check if ticket maintenance is enabled
    if (eventer_get_settings('eventer_enable_ticket_maintenance') !== 'on') {
        return;
    }

    // Define the directory where PDF tickets are stored
    $upload_dir = wp_upload_dir();
    $pdf_dir = $upload_dir['basedir'] . '/eventer';

    // Fetch all PDFs in the directory
    $pattern = "$pdf_dir/*.pdf";
    $all_files = glob($pattern);

    // Define the file age threshold (30 days)
    $file_age_threshold = 30 * DAY_IN_SECONDS;

    foreach ($all_files as $file) {
        if (filemtime($file) < (time() - $file_age_threshold)) {
            // Delete the file if it's older than the threshold
            unlink($file);
        }
    }
}

// Unschedule the cron job upon plugin deactivation
register_deactivation_hook(__FILE__, 'unschedule_ticket_maintenance_cron');
function unschedule_ticket_maintenance_cron() {
    $timestamp = wp_next_scheduled('eventer_ticket_maintenance_cron');
    if ($timestamp) {
        wp_unschedule_event($timestamp, 'eventer_ticket_maintenance_cron');
    }
}
?>