jQuery(document).ready(function ($) {
  let csvData = [];
  let csvMapping = {};

  $('#eventer-drop-area').on('click', function (e) {
    if (e.target.tagName !== 'INPUT') {
      $('#eventer-csv-file').trigger('click');
    }
  });

  $('#eventer-csv-file').on('change', function (e) {
    const file = e.target.files[0];
    if (!file) return;

    const reader = new FileReader();
    reader.onload = function (event) {
      const lines = event.target.result.split(/\r?\n/);
      const header = lines[0].split(',');
      csvData = lines.slice(1)
        .map(line => line.split(','))
        .filter(row => row.some(cell => cell.trim() !== ''));

      $('#eventer-preview-area').show();
      $('#eventer-preview-header').html('');
      header.forEach(h => {
        $('#eventer-preview-header').append('<th>' + h + '</th>');
      });

      const previewRows = csvData.slice(0, 5);
      $('#eventer-preview-body').html('');
      previewRows.forEach(row => {
        const tr = $('<tr></tr>');
        row.forEach(cell => {
          tr.append('<td>' + cell + '</td>');
        });
        $('#eventer-preview-body').append(tr);
      });

      const fields = [
        'Skip', 'Title', 'Content', 'Start Date', 'End Date',
        'All Events Date', 'Venue Title', 'Venue Location',
        'Organizer Name', 'Organizer Phone', 'Organizer Email', 'Organizer Website',
        'Event Category', 'Event Tags',
        'Featured Image', 'Featured Image (Lazy)'
      ];

      let mappingHtml = '';
      header.forEach((col, index) => {
        mappingHtml += '<div class="eventer-map-item">';
        mappingHtml += '<label>' + col + '</label>';
        mappingHtml += '<select data-index="' + index + '">';
        fields.forEach(field => {
          mappingHtml += '<option value="' + field + '">' + field + '</option>';
        });
        mappingHtml += '</select></div>';
      });
      $('#eventer-field-mapping').html(mappingHtml);
    };
    reader.readAsText(file);
  });

  $('#eventer-import-form').on('submit', function (e) {
    e.preventDefault();

    const postStatus = $('#eventer_post_status').val();
    const skipTitles = $('#eventer_skip_duplicate_titles').is(':checked') ? 1 : 0;
    const skipTerms = $('#eventer_skip_existing_terms').is(':checked') ? 1 : 0;

    csvMapping = {};
    $('#eventer-field-mapping select').each(function () {
      const index = $(this).data('index');
      const value = $(this).val();
      csvMapping[index] = value;
    });

    $('#eventer-progress').text('&#128228; Saving CSV...');
    $.post(eventerImport.ajax_url, {
      action: 'eventer_save_csv_data',
      nonce: eventerImport.nonce,
      data: csvData,
      mapping: csvMapping,
      skip_titles: skipTitles,
      skip_terms: skipTerms
    }, function (res) {
      if (res.success) {
        $('#eventer-progress').text('&#9989; CSV saved. Starting import...');
        startImport(postStatus);
      } else {
        $('#eventer-progress').text('&#10060; ' + res.data);
      }
    });
  });

  function startImport(status) {
    function processBatch() {
      $.post(eventerImport.ajax_url, {
        action: 'eventer_process_csv_batch',
        nonce: eventerImport.nonce,
        post_status: status
      }, function (res) {
        if (res.success) {
          if (res.data.complete) {
            $('#eventer-progress').html('<strong>&#9989; Import complete!</strong>');

            if (res.data.errors && res.data.errors.length > 0) {
              let logHtml = '<div class="eventer-import-log"><h3>&#9888; Import Warnings:</h3><ul>';
              res.data.errors.forEach(err => {
                logHtml += `<li>${err}</li>`;
              });
              logHtml += '</ul></div>';
              $('#eventer-progress').append(logHtml);
            } else {
              $('#eventer-progress').append('<div class="eventer-import-log"><p>No issues encountered during import &#127881;</p></div>');
            }

            $('#eventer-revert-import-wrap').show();
          } else {
            $('#eventer-progress').text(`&#9203; Processing... ${res.data.percent}%`);
            setTimeout(processBatch, 300);
          }
        } else {
          $('#eventer-progress').text('&#10060; ' + res.data);
        }
      });
    }

    processBatch();
  }

  $('#eventer-cancel-import').on('click', function () {
    $.post(eventerImport.ajax_url, {
      action: 'eventer_cancel_csv_import',
      nonce: eventerImport.nonce
    }, function (res) {
      if (res.success) {
        $('#eventer-progress').text('&#128683; Import cancelled.');
      } else {
        $('#eventer-progress').text('&#10060; Cancel failed: ' + res.data);
      }
    }).fail(function () {
      $('#eventer-progress').text('&#10060; AJAX error: Could not contact server.');
    });
  });

  $('#eventer-revert-import').on('click', function () {
    if (!confirm('Are you sure you want to revert the last import? This will delete all imported events.')) return;

    $('#eventer-progress').text('&#9851; Reverting last import...');

    $.post(eventerImport.ajax_url, {
      action: 'eventer_revert_import',
      nonce: eventerImport.nonce
    }, function (res) {
      if (res.success) {
        $('#eventer-progress').text(res.data.message);
        $('#eventer-revert-import-wrap').hide();
      } else {
        $('#eventer-progress').text('&#10060; Revert failed: ' + res.data);
      }
    }).fail(function () {
      $('#eventer-progress').text('&#10060; AJAX error during revert.');
    });
  });
});
